%{
/*
    $Id: xkeysw-yacc.y,v 1.3 2001/06/21 21:14:35 dima Exp $

    xkeysw - window bound/multi code keyboard switch
    Copyright (C) 2000  Dima Barsky <dima@debian.org>,
                        Igor Belyi  <ibelyi@yahoo.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdlib.h>
#include "xkeyswrc.h"

group_t* group_list = NULL;
keymap_t* keymap_list = NULL;

%}

%union{
    char* name;
    element_t* elem;
    keysym_t* keysym;
    value_t* value;
    define_t define;
}

%type <name> keymap_spec prefix group_spec
%type <elem> element element_list mod_list keymap_list
%type <elem> group_list group_except pattern
%type <keysym> keysym_define keymap_define
%type <value> values
%type <define> define

%token <name> NAME STRING PATTERN
%token GROUP EXCEPT KEYMAP INCLUDE KEYSYM NL

%start input

%%

input:		/* empty string */
	|	input define{
		    /*
		     * Add elements to group_list and keymap_list here to
		     * ensure that first element in the list is the first
		     * element in the file
		     */
		    switch($2.type) {
		    case group:
			$2.val.group->next = group_list;
			group_list = $2.val.group;
			break;
		    case keymap:
			$2.val.keymap->next = keymap_list;
			keymap_list = $2.val.keymap;
			break;
		    default:
			break;
		    }
		}
		
	;

define:		GROUP NAME '=' group_list group_except {
		    $$.type = group;
		    $$.val.group = (group_t*)malloc(sizeof(group_t));
		    $$.val.group->name = $2;
		    $$.val.group->pattern = $4;
		    $$.val.group->except = $5;
		}
	|	KEYMAP NAME prefix keymap_list '=' '{' keymap_define '}' {
		    $$.type = keymap;
		    $$.val.keymap = (keymap_t*)malloc(sizeof(keymap_t));
		    $$.val.keymap->name = $2;
		    $$.val.keymap->prefix = $3;
		    $$.val.keymap->keymap_list = $4;
		    $$.val.keymap->keysym_list = $7;
		}
	|	INCLUDE STRING {$$.type = include; includeFile($2);}
	;

group_except:	/* empty string */ {$$ = NULL;}
	|	EXCEPT group_list {$$ = $2;}
	;

group_list:	/* empty string */ {$$ = NULL;}
	|	pattern {
		    $$ = $1;
		}
	|	pattern ',' group_list {
		    $$ = $1;
		    $$->next = $3;
		}
	;

pattern:	PATTERN {
		    $$ = (element_t*)malloc(sizeof(element_t));
		    $$->type = pattern;
		    $$->name = $1;
		    $$->next = NULL;
		}
	|	NAME {
		    $$ = (element_t*)malloc(sizeof(element_t));
		    $$->type = name;
		    $$->name = $1;
		    $$->next = NULL;
		}
	;

keymap_list:	/* empty string */ {$$ = NULL;}
	|	NAME {
		    $$ = (element_t*)malloc(sizeof(element_t));
		    $$->type = name;
		    $$->name = $1;
		    $$->next = NULL;
		}
	|	NAME ',' keymap_list {
		    $$ = (element_t*)malloc(sizeof(element_t));
		    $$->type = name;
		    $$->name = $1;
		    $$->next = $3;
		}
	;

keymap_define:	/* empty string */ {$$ = NULL;}
	|	keysym_define keymap_define {
		    $$ = $1;
		    $$->next = $2;
		}
	;

keysym_define:	group_spec mod_list KEYSYM NAME '=' {beginNLmatch();} values NL {
		    $$ = (keysym_t*)malloc(sizeof(keysym_t));
		    $$->group_spec = $1;
		    $$->groupId = -1; /* initialize to "no group" */
		    $$->mod_list = $2;
		    $$->keysym = $4;
		    $$->values = $7;
		    beginInitial();
		}
	;

group_spec:	/* empty string */ {$$ = NULL;}
	|	GROUP NAME {$$ = $2;}
	;

prefix:		/* empty string */ {$$ = NULL;}
	|	'(' STRING ')' {$$ = $2;}
	;

mod_list:	/* empty string */ {$$ = NULL;}
	|	NAME mod_list {
		    $$ = (element_t*)malloc(sizeof(element_t));
		    $$->name = $1;
		    $$->type = name;
		    $$->next = $2;
		}
	;

values:		/* empty string */ {$$ = NULL;}
	|	element_list keymap_spec values {
		    $$ = (value_t*)malloc(sizeof(value_t));
		    $$->value = $1;
		    $$->keymap = $2;
		    $$->next = $3;
		}

	;

element_list:	/* empty string */ {$$ = NULL;}
	|	element {$$ = $1;}
	|	element ',' element_list {
		    $$ = $1;
		    $$->next = $3;
		}
	;

element:	STRING {
		    $$ = (element_t*)malloc(sizeof(element_t));
		    $$->type = string;
		    $$->name = $1;
		    $$->next = NULL;
		}
	|	NAME {
		    $$ = (element_t*)malloc(sizeof(element_t));
		    $$->type = name;
		    $$->name = $1;
		    $$->next = NULL;
		}
	;

keymap_spec:	/* empty string */ {$$ = NULL;}
	|	'/' NAME {$$ = $2;}
	;

%%

int yyerror (char *s) {
  fprintf(stderr, "error: %s\n", s);
  return 0;
}
