/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_TOOLS_H__
#define __SINGIT_TOOLS_H__

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <sys/stat.h>

gchar* tools_replace_string (const gchar *input_string,
	const gchar *token, const gchar *replacement);

gchar* tools_insert_string
	(const gchar *input_string, const gchar *token, guint offset);

/*
  Computes the intersection of line a and b (n = start / ln = length)  (n1 < n2 !)
  Returns TRUE if an intersection exists
*/
gboolean calc_line_intersection(gint a, guint la, gint b, guint lb, gint *r, guint *lr);

/*
  Computes the intersection of two rects (source, destination, result)
  Returns TRUE if an intersection exists
*/
gboolean calc_rect_intersection
	(gint left_s, gint top_s, guint width_s, guint height_s,
	 gint left_d, gint top_d, guint width_d, guint height_d,
	 gint *left_r, gint *top_r, guint *width_r, guint *height_r);

gint lines_length(const gchar **lines);
gint lines_count(const gchar **lines);
gboolean lines_info(const gchar **lines, guint *length, guint *count);

// Tries to create an absolute path
gboolean create_abs_path(const gchar* path, __mode_t mode);

// Return a string that is centered
gchar* create_centered_string(const gchar *input, guint size);

// Create a widget with a gtk data attached description
void create_std_wgt_description(GtkWidget *widget,
	const gchar* widget_var_name, gboolean show, GtkWidget *window);

// Extract the basename and cut of one extension by providing len
const gchar* extract_basename_noext(const gchar *filename, gint *len);

GtkWidget* lookup_widget (GtkWidget *widget, const gchar *widget_name);

// A little helper funtion to append a string to a translation
// You do not need to free it
gchar* transadd(const gchar *trans_str, const gchar *add);

#endif // __SINGIT_TOOLS__
