
#include "AbstractStrList.h"

AbstractStrList::AbstractStrList( XStrListOptsT inOption, CompFunctionT inCompFcn ) :
	AbstractStrAccess( inOption ) {

	mItems.SetCompFcn( inCompFcn, this );

	SetListOrdering( inOption );
}

void AbstractStrList::SetListOrdering( XStrListOptsT inNewOrder ) {

	// It's impt this assignment happens first b/c the sort will occur the below SetListOrdering() call
	mStrOrdering = inNewOrder;

	if ( inNewOrder == ASA_OrderImportant )
		mItems.SetListOrdering( cOrderImportant );
	else if ( inNewOrder == ASA_OrderNotImportant )
		mItems.SetListOrdering( cOrderNotImportant );
	else
		mItems.SetListOrdering( cSorted );
}

AbstractStrList::~AbstractStrList() {

}

void AbstractStrList::RemoveAll() {
	int			i = 1;
	void*		item;

	while ( mItems.Fetch( i, (void**) &item ) ) {

		DeleteItem( item );
		i++;
	}
	mItems.RemoveAll();
}

void AbstractStrList::Remove( long inIndex ) {
	void*	item;

	if ( mItems.Fetch( inIndex, &item ) )
		DeleteItem( item );

	mItems.RemoveElement( inIndex );
}
