#include "TimeBasedScript.h"

#include "GeneralFileSys.h"

TimeBasedScript::TimeBasedScript() {
	mNextCmdTime = 90000000;
}




bool TimeBasedScript::Assign( MirroredFileSys* inFileSys, FileObj inFileID ) {
	const UtilStr* name = inFileSys -> GetName( inFileID );
	
	// Files that start with a "$" aren't cached
	if ( name ) {
		if ( name -> getChar( 1 ) == '$' )
			inFileSys -> PurgeCached( inFileID, 0 );
	}
	
	if ( inFileSys -> Read( inFileID, mScriptBuf ) ) {
		
		return true;
	}
	
	return false;
}


bool TimeBasedScript::Assign( const CEgFileSpec* inSpec ) {
	CEgIFile iFile;
	
	iFile.open( inSpec );
	
	if ( iFile.noErr() && iFile.size() < 10000 ) {
	
		// Suck everything out of the file and set up a streaming buffer
		iFile.Read( mScriptBuf, iFile.size() );		
		return true;
	}
	
	return false;
}


void TimeBasedScript::Assign( const UtilStr& inCmdLine ) {

	mScriptBuf.Assign( "0:00 " );
	mScriptBuf.Append( inCmdLine );	
}




void TimeBasedScript::Start( float inTime ) {

	mScript.Tie( &mScriptBuf );
	
	mStartTime = inTime;
	mIsDone = false;
	mNextCmdTime = 0;
	PopNextEvent();
}



void TimeBasedScript::PopNextEvent() {
	float secs;
	long pos;
	
	// Read the "MM:SS" part of the script (a space or tab follows it)
	mScript.Read( mTemp );
	
	// Did we get a valid time index?
	if ( mTemp.length() ) {
	
		// Read both the minute and second ind turn it into a time index in seconds...
		pos = mTemp.FindNextInstanceOf( 0, ':' );
		mTemp2.Assign( mTemp.getCStr() + pos, mTemp.length() - pos );
		mTemp.Keep( pos - 1 ); 
		secs = mTemp2.GetFloatValue() + 60 * mTemp.GetValue();
		
		// If the time is crap, don't use it.
		if ( secs > mNextCmdTime )
			mNextCmdTime = secs;  }
			
	// Make it impossible to get the next event
	else {
		mNextCmdTime = 90000000;
		mIsDone = true;
	}		
}



bool TimeBasedScript::GetNextCmd( float inTime, UtilStr& outCmd ) {
	
	// See if we're due for the next event...
	if ( inTime - mStartTime >= mNextCmdTime ) {
		
		mScript.Readln( outCmd );
		PopNextEvent();
		
		return true;
	}
	
	return false;
}


