/*  XMMS STATUS PLUGIN - Status Docklet Plugin for XMMS
 *  Copyright (C) 2000  Ian Campbell.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>

#include "xmms-status-plugin.h"


static GtkWidget *about_dialog = NULL;

static void about_close_callback(GtkWidget *w);

static void about_close_callback(GtkWidget *w)
{
	gtk_widget_destroy(about_dialog);
	about_dialog = NULL;
}

void status_docklet_about(void)
{
	GtkWidget *label, *button;

	if ( about_dialog )
		return;

	about_dialog = gtk_dialog_new ();

	gtk_window_set_title(GTK_WINDOW(about_dialog), _("About XMMS Status Docklet"));
	gtk_container_border_width(GTK_CONTAINER(about_dialog), 5);

	label = gtk_label_new ( _ ("XMMS Status Docklet Plugin\n\n "
				   "Created By Ian Campbell <ijc@hellion.org.uk>\n "
				   "Shows a status docklet in the GNOME or KDE panel.\n") );
	
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(about_dialog)->vbox), label, TRUE, TRUE, 0);
	
	button = gtk_button_new_with_label(_(" Close "));
	gtk_signal_connect(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(about_close_callback), NULL);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(about_dialog)->action_area), button, FALSE, FALSE, 0);
	
	gtk_widget_show(label);
	gtk_widget_show(button);
	gtk_widget_show(about_dialog);
	gtk_widget_grab_focus(button);

}
