/*
 * $COPYRIGHT$
 *
 *	$Id: args.h,v 1.3 1999/08/15 21:05:00 lamteam Exp $
 *
 *	Function:	- command line argument parsing
 */

#ifndef _ARGS
#define _ARGS

#include "lam.h"

#ifdef __cplusplus
extern "C" {
#endif

/*
 * argument vector package
 */
extern int	sfh_argv_add __ARGS((int *, char ***, char *));
extern int	sfh_argv_count __ARGS((char **));
extern void	sfh_argv_free __ARGS((char **));
extern char	**sfh_argv_break __ARGS((const char *, int));
extern char	**sfh_argv_dup __ARGS((char **));
extern char	*sfh_argv_glue __ARGS((char **, int, unsigned int));
extern unsigned int
		sfh_argv_len __ARGS((char **));

/*
 * backwards compatible option interfaces
 */
extern int	argvadd __ARGS((int *argc,
				char ***argv, const char *arg));
extern int	argvcount __ARGS((char **argv));
extern int	argvlen __ARGS((char **argv));
extern char	**argvdup __ARGS((char **argv));
extern char	*argvglue __ARGS((char **argv, int delim, int maxlen));
extern char	**argvbreak __ARGS((const char *args, int delim));
extern void	argvfree __ARGS((char **argv));
		
extern int	do_args __ARGS((int *argcp, char **argv));
extern int	expand_nodes __ARGS((void));
extern int	get_2nd_let __ARGS((int let));
extern int	intparam __ARGS((int c, int *p));
extern int	opt_chosen __ARGS((int o));
extern int	opt_taken __ARGS((int let));
extern int	xtoi __ARGS((char **cpp, int *ip));
extern char	*getparam __ARGS((int let));
extern void	exclusive __ARGS((const char *str));
extern void	followed __ARGS((const char *str));
extern void	free_nodes __ARGS((void));
extern void	twoletter __ARGS((const char *str));
extern void	validopts __ARGS((const char *str));

/*
 * ID parsing package
 */
extern int	nid_parse __ARGS((int *argc, char **argv));
extern int	pid_parse __ARGS((int *argc, char **argv));
extern int4	nid_count __ARGS((void));
extern int4	nid_parse1 __ARGS((char *s));
extern char	*nid_fmt __ARGS((int4 node));
extern void	nid_get __ARGS((int *ixp, int *idp, int *flp));
extern void	pid_get __ARGS((int *ixp, int *idp, int *flp));
extern void	nid_free __ARGS((void));
extern void	pid_free __ARGS((void));
extern void	nid_usage __ARGS((void));

/*
 * backwards compatible ID interfaces
 */
extern int	parse_nodes __ARGS((int *argc, char **argv));
extern int	parse_procs __ARGS((int *argc, char **argv));
extern int4	mnnodeid __ARGS((const char *string));
extern char	*mnemonic __ARGS((int4 node));
extern void	getnode __ARGS((int *ixp, int *idp, int *flagsp));
extern void	getproc __ARGS((int *ixp, int *idp, int *flagsp));
extern void	mnusage __ARGS((void));

/*
 * Other things that are in libargs.a, currently for lack of a better
 * place to put them
 */
extern void     show_help __ARGS((char *program, char *topic, ...));

#ifdef __cplusplus
}
#endif

#endif	/* _ARGS */
