/*
 *	$COPYRIGHT$
 *
 *	$Id: xmpi_dbase.h,v 1.5 2000/11/01 06:17:33 bbarrett Exp $
 *
 *	Function:	- database templates and constants
 */

#ifndef _XMPIDB
#define _XMPIDB

#include "all_list.h"
#include "xmpi.h"
#include "mpitrace.h"

/*
 * constants
 */
#define XMPI_DBNTRACES	64			/* initial # traces */
#define XMPI_DBNARROWS	64			/* initial # arrows */

/*
 * structures
 */
struct xmdb {
	int		xdb_nprocs;		/* # processes */
	struct xmdbproc	*xdb_procs;		/* process array */
	LIST		*xdb_cids;		/* list of context IDs */
	double		xdb_mintime;		/* min traces time (sec) */
	double		xdb_maxtime;		/* max traces time (sec) */
	double		xdb_curtime;		/* current time (sec) */
	double		xdb_minlapse;		/* mimimum trace lapse (sec) */
};

struct xmdbproc {
	int		xdbp_node;		/* process nodeid */
	int		xdbp_pid;		/* process ID */
	char		xdbp_prog[TRDPROGMAX];	/* program name */
	LIST		*xdbp_traces;		/* list of traces */
	LIST		*xdbp_dtypes;		/* list of datatypes */
	LIST		*xdbp_msgsnd;		/* list of msg senders */
        LIST            *xdbp_buoys;            /* list of buoys */

	struct xmdbtr	*xdbp_curtrace;		/* current trace */
};

struct xmdbcid {
	int		xdbc_cid;		/* context ID */
	int		xdbc_nlprocs;		/* # local processes */
	int		xdbc_nrprocs;		/* # remote processes */
	struct _gps	*xdbc_lgrp;		/* ptr local group GPS */
	struct _gps	*xdbc_rgrp;		/* ptr remote group GPS */
};

struct xmdbenv {
	int		xdbe_func;		/* function */
	int		xdbe_lpeer;		/* peer local rank */
#define xdbe_lroot	xdbe_lpeer		/* root local rank */
	int		xdbe_tag;		/* message tag */
	int		xdbe_cid;		/* context ID */
  char*           xdbe_commname;
	int		xdbe_dtype;		/* datatype */
	int		xdbe_count;		/* data count */
	int		xdbe_mlpeer;		/* matched peer local rank */
	int		xdbe_mtag;		/* matched message tag  */
	int		xdbe_seqnum;		/* message sequence number */
	int		xdbe_wfunc;		/* wrapper function */
};

struct xmdbtr {
	double		xdbt_time;		/* start time (sec) */
	double		xdbt_lapse;		/* time lapse (sec) */
	int		xdbt_grank;		/* process global rank */
	int		xdbt_state;		/* trace state */
	struct xmdbenv	xdbt_envelop;		/* message envelop */
	double		xdbt_systotal;		/* total system time */
	double		xdbt_blktotal;		/* total block time */
	int		xdbt_arrowdir;		/* arrow direction */
#define XMPI_DBNA	0			/* no arrow */
#define XMPI_DBIN	1			/* incoming arrow */
#define XMPI_DBOUT	2			/* outgoing arrow */
	int		xdbt_arrowloc;		/* arrow location */
#define XMPI_DBSTART	0			/* arrow at start time */
#define XMPI_DBEND	1			/* arrow at end time */
	struct xmdbtr	*xdbt_arrow;		/* ptr in/out arrow */
	struct xmdbtr	**xdbt_senders;		/* ptr in senders list */
};

struct xmdbbuoy {
        char            xdbb_name[32];          /* buoy name */
        double          xdbb_time;              /* start time (sec) */
};


struct xmdbdt {
	int		xdbd_dtype;		/* datatype number */
	char		*xdbd_dtbuf;		/* datatype buffer */
};

/*
 * data structures used in parsing
 */
struct onoff {
	int		oo_segment;		/* segment number */
	double		oo_ontime;		/* time switched on */
	double		oo_offtime;		/* time switched off */
	int		oo_inoff;		/* init/on/off lst off found */
	int             oo_rton;		/* runtime trace on found */
	int             oo_rtoff;		/* runtime trace off found */
};

struct dbparse {
	int		dbp_top;		/* top-level function */
	int		dbp_sub;		/* substrate */
	double		dbp_start;		/* start time */
	double		dbp_end;		/* current end time */
	double		dbp_blktot;		/* blk time total */
	double		dbp_systot;		/* system time total */
	double		dbp_skew;		/* clock skew */
	LIST		*dbp_senders;		/* sender list */
	LIST		*dbp_segs;		/* segment list */
	struct onoff	*dbp_curseg;		/* current segment */
};


/*
 * global functions
 */
int xmpi_db_getarrows(double, double, struct xmarrow**);

void xmpi_db_getcomm(int, int, struct _gps**, int*, int*, int*);

int xmpi_db_getgpeer(int, int, int);

int xmpi_db_getlpeer(int, int, int);

int xmpi_db_getload(int, double*, double*);

int xmpi_db_getnprocs();

int xmpi_db_gettraces(double, double, struct xmtrace**);

void *xmpi_db_getdtype(int, int);

double xmpi_db_getmaxtime();

double xmpi_db_getmintime();

double xmpi_db_getminlapse();

int xmpi_db_getmaxtraces();

int xmpi_db_getstat(int, struct xmproc*);

void xmpi_db_settime(double);

int xmpi_db_getbuoys(struct xmbuoy**);

#endif	/* _XMPIDB */
