/*
 *	$COPYRIGHT$
 *
 *	$Id: xmpi_help.cc,v 1.3 2000/10/29 19:32:02 bbarrett Exp $
 *
 *	Function:	- XMPI help
 */

#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "args.h"
#include "xmpi.h"
#include "xmpi_help.h"
#include "xmpi_error.h"


/*
 * private functions
 */
extern "C" {
static void childtrap(int);
}

/*
 * private variables
 */
static int help_pid = 0;

/*
 *	xmpi_help
 *
 *	Function:	- fork-exec help
 */
void
xmpi_help()
{
  char errbuf[512];

  char **argv;

  int pid;

  struct sigaction
   chld;			       /* SIGCHLD action */

  if (help_pid > 0)
    return;

  if (app_res.ap_helpcmd == 0 || strlen(app_res.ap_helpcmd) == 0) {
    return;
  }
  argv = argvbreak(app_res.ap_helpcmd, ' ');

  if (argv == 0) {
    xmpi_error(0, (char*) "xmpi_help (argvbreak)");
  } else {

    chld.sa_handler = childtrap;
    chld.sa_flags = SA_NOCLDSTOP;
    sigemptyset(&chld.sa_mask);
    sigaction(SIGCHLD, &chld, (struct sigaction *) 0);

    if ((pid = fork()) < 0) {
      xmpi_error(0, (char*) "xmpi_help (fork)");
    } else if (pid == 0) {
      execvp(argv[0], argv);
      sprintf(errbuf, "xmpi: ERROR in help command \"%s\"",
	      app_res.ap_helpcmd);
      perror(errbuf);
      exit(errno);
    } else {
      help_pid = pid;
    }
  }
}

/*
 *	childtrap
 *
 *	Function:	- traps child process termination
 */
static void
childtrap(int)
{
  int status;

  if (help_pid > 0) {
    if (waitpid(help_pid, &status, WNOHANG) > 0) {
      help_pid = 0;
    }
  }
}
