/*
 *  /proc/pmu parsing for xpmumon.
 *
 *  Copyright (c) 2002  Brendan O'Dea <bod@debian.org>
 *
 *  This is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "misc.h"
#include "carp.h"
#include "pmu.h"

RCS_Id("$Id: pmu.c,v 1.1 2002/01/20 07:14:25 bod Exp $")

#define PMU_DIR "/proc/pmu/"

int read_info(char const *key)
{
    FILE *info = fopen(PMU_DIR "info", "r");
    int key_sz = strlen(key);
    char buf[BUFSIZ];

    if (!info)
	croak(1, 1, "can't open %s", PMU_DIR "info");

    while (fgets(buf, sizeof(buf), info))
    {
	char *p;
	if (!strncmp(buf, key, key_sz) && (p = strchr(buf, ':')))
	{
	    fclose(info);
	    return atoi(++p);
	}
    }

    croak(1, 0, "can't find %s in %s", key, PMU_DIR "info");
}

struct batt_info *read_battery(int batt)
{
    static struct batt_info r;
    FILE *info;
    char path[] = PMU_DIR "battery_N";
    char buf[BUFSIZ];

    path[sizeof(path) - 2] = '0' + batt;
    if (!(info = fopen(path, "r")))
	croak(1, 1, "can't open %s", path);

#define FIELD_FLAGS		"flags"
#define FIELD_CHARGE		"charge"
#define FIELD_MAX_CHARGE	"max_charge"
#define FIELD_CURRENT		"current"
#define FIELD_VOLTAGE		"voltage"
#define FIELD_TIME_REM		"time rem."

    r.flags = r.charge = r.max_charge = r.current = r.voltage =
	r.time_rem = 0;

    while (fgets(buf, sizeof(buf), info))
    {
	int *field;
	char *p;

	if (!strncmp(buf, FIELD_FLAGS, sizeof(FIELD_FLAGS)-1))
	    field = &r.flags;
	else if (!strncmp(buf, FIELD_CHARGE, sizeof(FIELD_CHARGE)-1))
	    field = &r.charge;
	else if (!strncmp(buf, FIELD_MAX_CHARGE, sizeof(FIELD_MAX_CHARGE)-1))
	    field = &r.max_charge;
	else if (!strncmp(buf, FIELD_CURRENT, sizeof(FIELD_CURRENT)-1))
	    field = &r.current;
	else if (!strncmp(buf, FIELD_VOLTAGE, sizeof(FIELD_VOLTAGE)-1))
	    field = &r.voltage;
	else if (!strncmp(buf, FIELD_TIME_REM, sizeof(FIELD_TIME_REM)-1))
	    field = &r.time_rem;
	else
	    continue;

	if (!(p = strchr(buf, ':')))
	    croak(1, 0, "unparsable line in %s: %s", path, buf);

	*field = atoi(p+1);
    }

    fclose(info);
    return &r;
}
