/*

    xpuyopuyo - pconfig.h     Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Header for game configuration code
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __pconfig_h_defined
#define __pconfig_h_defined


#if TIME_WITH_SYS_TIME        /* Setup time headers */
#  include <sys/time.h>
#  include <time.h>
#else
#  if HAVE_SYS_TIME_H
#    include <sys/time.h>
#  else
#    include <time.h>
#  endif
#endif


/* We need the data types and high scores structure; 
   a fake pointer won't suffice */
#include <xpuyopuyo.h>
#include <phighscore.h>


/* Forward declarations */
struct _pwindow;              /* Forward declaration of pwindow */
struct _pplayer;              /* Forward declaration for player */
struct _aiinfo;               /* Forward declaration of AI */
#if USE_NETWORK
struct _psocket;              /* Forward declaration of network socket node */
#endif
#if USE_SOUND
struct _p_sound;              /* Sound channel forward declaration */
#endif


/* Configuration structure  -- see field comments for descriptions. */
typedef struct _pconfig {
   /* Options related to players */
   int      numplayers;       /* Number of players in this game. */
   int      ai;               /* Nonzero if the AI is playing. */
   int      networked;        /* Number of network players involved */

   /* Options related to difficulty */
   int      numcolors;        /* Number of colored blobs */
   int      dropspeed;        /* Initial dropping speed, in milliseconds */
   double   accel;            /* Acceleration, in % time lost per minute */
   bool     aicandrop;        /* If T, AI can drop when human drops */
   bool     nullifyrocks;     /* If T, allowed to NULLIFY rocks when we want to */
   bool     indestructibles;  /* If T, allow indestructible rocks */
   bool     quiet;            /* If T, do not print verbose messages */
   bool     nodisplay;        /* If T, playfields are not displayed */
   bool     tooltips;         /* If T, tooltips are displayed */
   
   /* Options related to size */
   int      fieldwidth;       /* Width of play field, per player */
   int      fieldheight;      /* Height of play field, per player */
   int      fieldmatch;       /* Minimum of colored blob chain for a match */
   
   /* Miscellaneous options */
   bool     aiscore;          /* If nonzero, show AI rule scores */
   bool     restart;          /* Can auto-restart if nonzero */
   bool     tutorial;         /* If true, game is in "tutorial" mode */

   /* AI control only */
   #if USE_AIBREED
   bool     tournament;       /* If nonzero, game is in "tournament" mode for AI's */
   bool     hypertournament;  /* Fast, looping tournament play if nonzero */
   int      tcurround[P_AI_COUNT]; /* AI's participating in tournament */
   int      tnextround[P_AI_COUNT];/* AI's participating in next round */
   #endif /* Only enabled if breeding */
   
   /* If network is enabled ... */
   #if USE_NETWORK
   struct _psocket *socket;   /* Socket connection (server or client, if non-null) */
   bool     networkai;        /* T if AI is allowed to play in a network game */
   #endif /* Network enabled? */
   
   /* Sound support? */
   #if USE_SOUND
   bool     enablesound;      /* True if sound is permitted */
   bool     usehqmixer;       /* True if mix with hqmixer.. */
   bool     useeffects;       /* true if sound effects enabled */
   struct _p_sound *sound;    /* Sound channel */
   #endif /* Sound supported? */

   /* Theme information */
   char     theme[P_THEME_NAME_SIZE];  /* Selected theme name */

   /* Runtime data */
   struct _pwindow *window;   /* Pointer to window structure */
   struct _pplayer *player[2];/* Player data */
   struct _aiinfo  *airules;  /* AI Ruleset */
   bool     paused;           /* If true, game is paused */
   bool     waiting;          /* Waiting (for a network event, usually) */
   int      whose_turn;       /* Turns are processed in order */
   struct timeval t1;         /* Start time for game */
   struct timeval t2;         /* Last time window updated (i think?) */
   double   realspeed;        /* Real drop time (= droptime at begin) */
   phigh    high[P_HIGH_SCORE_COUNT];   /* High scores list */
   struct timeval timerupdate;/* Set to last time the timer was updated */
   bool     needredraw;       /* Imply redraw-all if set */
} pconfig;


/* Functions for managing a pconfig */
pconfig *p_config_new(int *argc, char ***argv);
void p_config_initialise(pconfig *c);
void p_config_free(pconfig **c);
void p_config_save(const pconfig *c);


#endif
