/*
# X-BASED DIAL
#
#  DialP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Dial */

#ifndef _DialP_h
#define _DialP_h

#include <stdlib.h>
#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "Dial.h"

#define MAXSEGMENTS 200

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?-1:1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

typedef struct _DialPart {
	Pixel indicatorColor;
	Pixel foreground;
	int angle;
	int minimum, maximum;
	int val;
	int markers;
	Boolean versionOnly;
	Position markerLength;
	Position innerDiam, outerDiam;
	XPoint indicator, center;
	GC dialGC;
	GC indicatorGC;
	GC inverseGC;
	XSegment segments[MAXSEGMENTS];
	XtCallbackList select;
} DialPart;

typedef struct _DialRec {
	CorePart core;
	DialPart dial;
} DialRec;

typedef struct _DialClassPart {
	int ignore;
} DialClassPart;

typedef struct _DialClassRec {
	CoreClassPart coreClass;
	DialClassPart dialClass;
} DialClassRec;

extern DialClassRec dialClassRec;

void calculate_indicator_pos(DialWidget w);
#endif /* _DialP_h */
