#define ANIMATE 1
/*-
# X-BASED HEXAGONS
#
#  Hexagons.h
#
###
#
#  Copyright (c) 1994 - 2006	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Hexagons */

#ifndef _XtHexagons_h
#define _XtHexagons_h

/***********************************************************************
 *
 * Hexagons Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNframeColor ((char *) "frameColor")
#define XtNtileColor ((char *) "tileColor")
#define XtNtileBorder ((char *) "tileBorder")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNsizeX ((char *) "sizeX")
#define XtNsizeY ((char *) "sizeY")
#define XtNcorners ((char *) "corners")
#define XtNbase ((char *) "base")
#define XtNuserName ((char *) "userName")
#define XtNscoreFile ((char *) "scoreFile")
#define XtNscoreOnly ((char *) "scoreOnly")
#define XtNversionOnly ((char *) "versionOnly")
#define XtNmenu ((char *) "menu")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNselectCallback ((char *) "selectCallback")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCSizeX ((char *) "SizeX")
#define XtCSizeY ((char *) "SizeY")
#define XtCCorners ((char *) "Corners")
#define XtCBase ((char *) "Base")
#define XtCUserName ((char *) "UserName")
#define XtCScoreFile ((char *) "ScoreFile")
#define XtCMenu ((char *) "Menu")

typedef struct _HexagonsClassRec *HexagonsWidgetClass;

extern WidgetClass hexagonsWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} hexagonsCallbackStruct;
#endif

#define PUZZLE_HIDE (-8)
#define PUZZLE_CLEAR_QUERY (-7)
#define PUZZLE_SOLVE_MESSAGE (-6)
#define PUZZLE_RESTORE (-5)
#define PUZZLE_RESET (-4)
#define PUZZLE_BLOCKED (-3)
#define PUZZLE_SPACE (-2)
#define PUZZLE_IGNORE (-1)
#define PUZZLE_MOVED 0
#define PUZZLE_SOLVED 1
#define PUZZLE_PRACTICE 2
#define PUZZLE_RANDOMIZE 3
#define PUZZLE_DEC_X 4
#define PUZZLE_INC_X 5
#define PUZZLE_DEC_Y 6
#define PUZZLE_INC_Y 7
#define PUZZLE_CORNERS 8
#define PUZZLE_COMPUTED 9
#define PUZZLE_UNDO 10
#define PUZZLE_REDO 11
#define PUZZLE_SPEED 12

#define MENU_GET 0
#define MENU_WRITE 1
#define MENU_EXIT 2
#define MENU_UNDO 3
#define MENU_REDO 4
#define MENU_CLEAR 5
#define MENU_RANDOMIZE 6
#define MENU_SOLVE 7
#define MENU_MODE 8
#define MENU_SPEED 9
#define MENU_SLOW 10
#define MENU_SOUND 11

#define MINTILES 1
#define DEFAULTTILESX 3
#define DEFAULTTILESY 3
#define MAXORIENT 2
#define NOCORN 0
#define CORNERS 1
#define DEFAULTCORNERS CORNERS
#define DEFAULTDELAY 10
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 10

typedef struct _HexagonsRec *HexagonsWidget;

#endif /* _XtHexagons_h */
/* DON'T ADD STUFF AFTER THIS #endif */
