// file      : xsde/cxx/qname.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSDE_CXX_QNAME_HXX
#define XSDE_CXX_QNAME_HXX

#include <xsde/cxx/config.hxx>

namespace xsde
{
  namespace cxx
  {
    class qname
    {
    public:
#ifndef XSDE_EXCEPTIONS
      enum error
      {
        error_none,
        error_no_memory
      };
#endif

      ~qname ();

      // The default c-tor creates an uninitialized qname. Use
      // modifiers to initialize it.
      //
      qname ();

#ifdef XSDE_EXCEPTIONS
      explicit
      qname (const char* name);
      qname (const char* prefix, const char* name);
#endif

      void
      swap (qname&);

    private:
      qname (const qname&);

      qname&
      operator= (const qname&);

    public:
      char*
      prefix ();

      const char*
      prefix () const;

#ifndef XSDE_EXCEPTIONS
      error
#else
      void
#endif
      prefix (const char*);

      char*
      detach_prefix ();

      void
      attach_prefix (char*);

    public:
      char*
      name ();

      const char*
      name () const;

#ifndef XSDE_EXCEPTIONS
      error
#else
      void
#endif
      name (const char*);

      char*
      detach_name ();

      void
      attach_name (char*);

    private:
      char* prefix_;
      char* name_;
    };

    bool
    operator== (const qname&, const qname&);

    bool
    operator!= (const qname&, const qname&);
  }
}

#include <xsde/cxx/qname.ixx>

#endif  // XSDE_CXX_QNAME_HXX
