// file      : tests/cxx/parser/validation/built-in/uri/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2006-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

// Test the built-in anyURI type validation.
//
#include <string>
#include <cassert>

// Let the runtime header sort out which version (stl/no-stl) to
// include.
//
#include <xsde/cxx/parser/validating/xml-schema-pimpl.hxx>

using namespace xsde::cxx::parser::validating;

int
main (int argc, char* argv[])
{
  using std::string;

  // Good.
  //
  {
    uri_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("  ");
    p._post ();
    assert (!p._error_type () && p.post_uri () == string (""));
  }

  {
    uri_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("relative");
    p._post ();
    assert (!p._error_type () && p.post_uri () == string ("relative"));
  }

  {
    uri_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("#id");
    p._post ();
    assert (!p._error_type () && p.post_uri () == string ("#id"));
  }

  {
    uri_pimpl p;
    p.pre ();
    p._pre ();
    p._characters ("http://www.example.com/foo#bar");
    p._post ();
    assert (!p._error_type () &&
            p.post_uri () == string ("http://www.example.com/foo#bar"));
  }
}
