/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _EAP_H_
#define _EAP_H_

#define EAP_REQUEST       1
#define EAP_RESPONSE      2
#define EAP_SUCCESS       3
#define EAP_FAILURE       4

#define EAP_TYPE_IDENTITY 1
#define EAP_TYPE_NOTIFY   2
#define EAP_TYPE_NAK      3

#define EAP_REQUEST_ID     1
#define EAP_REQUEST_AUTH   2
#define EAP_REQUEST_NOTIFY 3

#define NO_EAP_AUTH      -1

struct generic_eap_data {
  void *eap_conf_data;       // Pointer to the configuration information for
                             // the EAP type we are going to use.

  char ias_quirk;			 

  void *eap_data;            // Pointer to EAP type specific state data.

  char *identity;            // Pointer to parent's ID

  char *tempPwd;             // Pointer to a temporary password.

  int eapid;                 // The EAP ID of the packet we are working with.

  int eapNum;                // The EAP type we are working with.

  int need_password;         // The EAP method should set this to 1 when it
                             // requires a password, or other challenge data
                             // from a GUI interface.

  char *eaptype;             // When a password is needed, the EAP handler
                             // should identify itself by putting a text
                             // version of it's name here.  Otherwise, it 
                             // this variable should be NULL.

  char *eapchallenge;        // When an EAP method requires some sort of 
                             // challenge be displayed to the user in order 
                             // for them to generate the proper password data.
  
  char *intName;             // A pointer to the interface name that we are
                             // working with. (Mostly for IPC purposes.)
};

void eap_init(struct interface_data *);
void eap_reset(struct interface_data *);
char eap_response_id(struct interface_data *);
void eap_cleanup(struct generic_eap_data **);
int eap_process_header(struct interface_data *);
void eap_do_notify(struct interface_data *);
char eap_response_auth(struct interface_data *);
void eap_prepopulate_id(struct interface_data *);
void eap_request_id(char *, int,  char *, int *);
int eap_create_active_method(struct generic_eap_data **, char *, char *,
			     char *);
int eap_request_auth(struct generic_eap_data *, struct config_eap_method *, 
		     char *, int, char *, int *);
int eap_clear_active_method(struct generic_eap_data *);
int eap_get_keying_material(struct interface_data *);
int eap_do_fail(struct generic_eap_data *);

#endif

