/*

    ToolBus -- The ToolBus Application Architecture
    Copyright (C) 1998-2000  Stichting Mathematisch Centrum, Amsterdam, 
                             The  Netherlands.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

*/
#ifndef __PROCS_H__
#define  __PROCS_H__

typedef enum pkind
{
  /* types */

  type_bool = 0,
  type_int,
  type_real,
  type_str,
  type_bstr,
  type_list,
  type_term,

  /* undefined */
  sym_undefined,
 
  /* system module */
  system_module,

  /* atomic functions */

  a_delta, a_tau,
  a_snd_msg, a_rec_msg,
  a_snd_note, a_rec_note,  a_no_note, a_subscribe, a_unsubscribe,
  a_snd_eval, a_rec_value, a_snd_cancel, a_snd_do, 
  a_rec_event, a_snd_ack_event,
  a_create,
  a_rec_connect,
  a_rec_disconnect, 
  a_snd_execute_to_tool, a_snd_terminate,
  a_shutdown,
  a_assign,
  a_endlet,
  a_printf,
  a_read,
  a_rec_attach_monitor, a_rec_detach_monitor,
  a_snd_monitor,
  a_rec_continue,

  /* atoms generated by tools: */
  a_snd_connect,                /* should be first */
  a_snd_value, a_snd_void,
  a_snd_event,
  a_snd_continue, a_snd_attach_monitor, a_snd_detach_monitor,
  a_snd_reconfigure,
  a_snd_disconnect,              /* should be last */

  /* atoms received by tools: */
  a_rec_eval, a_rec_cancel, a_rec_do, a_rec_ack_event, a_rec_terminate,
  a_rec_monitor,

  /* process operators */
  p_plus,                         /* should be first */
  p_dot, p_star, p_call, p_semi,
  p_fmerge, p_lmerge,
  p_if,
  p_let,
  p_execute,
  p_timer, p_delay, p_abs_delay, p_timeout, p_abs_timeout,
  p_no_delay, p_no_timeout,

  /* process definitions and representations */
  s_proc_def,                     /* should be first */
  s_proc_inst,
  s_tool_inst,

  mon_logger,
  mon_viewer,
  mon_controller,
  
  /* symbols in expressions */

  e_is_bool,                      /* should be first */
  e_is_int, e_is_real, e_is_str, e_is_bstr, e_is_appl, e_is_list,
  e_is_empty, e_is_var, e_is_result_var, e_is_formal,
  e_fun, e_args,

  e_true, e_false,
  e_not, e_and, e_or, e_equal, e_not_equal,
  e_add, e_sub, e_mul, e_div, e_mod, e_abs,
  e_less, e_less_equal, e_greater, e_greater_equal,

  e_radd, e_rsub, e_rmul, e_rdiv,
  e_rless, e_rless_equal, e_rgreater, e_rgreater_equal,
  e_sin, e_cos, e_atan, e_atan2, e_exp, e_log, e_log10,
  e_sqrt, e_rabs,

  e_size, e_index, e_replace,
  e_get, e_put, e_first, e_next,
  e_member, e_subset, 
  e_diff, e_inter, e_join, e_functions,

  e_process_id, e_process_name, e_quote,
  e_current_time, e_sec,
  e_msec                       /* should be last */

} pkind;


/* ----------------- coords ---------------------------------- */

typedef term_list coords;

#define mk_coords(src, lino, pos, elino, epos) \
        mk_list5(src, mk_int(lino), mk_int(pos), mk_int(elino), mk_int(epos))

#define co_src(c)      elm1(c)
#define co_lino(c)     elm2(c)
#define co_pos(c)      elm3(c)
#define co_elino(c)    elm4(c)
#define co_epos(c)     elm5(c)

#define is_coords(c)   (!c || (is_list(c) && (list_length(c) == 5)))

/* ------------------ atoms ------------------------------------ */

typedef term atom;

#define mk_atom(af,args,c) mk_appl4(af, args, NULL, c, NULL) 

#define at_fun(a)      fun_sym(a)
#define at_args(a)     elm1(fun_args(a))
#define at_conds(a)    elm2(fun_args(a))
#define at_coords(a)   elm3(fun_args(a))
#define at_env(a)      elm4(fun_args(a))

#define mk_conds(abs_delay,abs_timeout,test)\
        mk_list3(mk_int(abs_delay), mk_int(abs_timeout), test)

#define conds_abs_delay(cds)   int_val(elm1(cds))
#define conds_abs_timeout(cds) int_val(elm2(cds))
#define conds_test(cds)                elm3(cds)

#define is_at_sym(af)  (af < p_plus)
#define is_atom(a)     ((a) && is_appl(a) && is_at_sym(fun_sym(a)))

#define is_to_tool_atom(a) ((a) && ((fun_sym(a) == a_rec_eval) ||\
				    (fun_sym(a) == a_rec_cancel) ||\
				    (fun_sym(a) == a_rec_do) ||\
				    (fun_sym(a) == a_rec_ack_event) ||\
				    (fun_sym(a) == a_rec_terminate) ||\
				    (fun_sym(a) == a_rec_monitor)))

#define is_from_tool_atom(a) ((a) && ((fun_sym(a) == a_snd_value) ||\
				       (fun_sym(a) == a_snd_event) ||\
				       (fun_sym(a) == a_snd_connect) ||\
				       (fun_sym(a) == a_snd_disconnect) ||\
				       (fun_sym(a) == a_snd_continue)))

#define is_legal_from_tool(ft) ((ft >= a_snd_connect) && (ft <= a_snd_disconnect))

TBbool     communicate(sym_idx, sym_idx);
sym_idx    reverse_role(sym_idx);

/* ------------------- procs --------------------------------- */

typedef term proc;

proc      *mk_create(char *, term_list *, var *, coords *);
proc      *mk_proc_call(char *, term *);

#define mk_dot(p1,p2)  (is_delta(p1) ? p1 : mk_appl2(p_dot,p1,p2))
#define mk_semi(p1,p2) mk_appl2(p_semi,p1,p2)
#define mk_plus(p1,p2) (is_delta(p1) ? p2 : \
                                      (is_delta(p2) ? p1 : \
				           mk_appl2(p_plus,p1,p2)))
#define mk_star(p1,p2)   mk_appl2(p_star,p1,p2)
#define mk_fmerge(p1,p2) (term_equal(p1, p2) ? p1 : mk_appl2(p_fmerge,p1,p2))
#define mk_lmerge(p1,p2)  mk_appl2(p_lmerge,p1,p2)

#define mk_if(tst,th,el) mk_appl3(p_if, tst, th, el)
#define if_test(p)      elm1(fun_args(p))
#define if_then(p)      elm2(fun_args(p))
#define if_else(p)      elm3(fun_args(p))

#define mk_let(vars,p)   mk_appl3(p_let,vars,p,NULL)
#define let_vars(p)      elm1(fun_args(p))
#define let_body(p)      elm2(fun_args(p))
#define let_env(p)       elm3(fun_args(p))

#define mk_execute(t,mv,c)\
        mk_appl3(p_execute, t, mv, c)

#define is_proc(p)     ((p) && is_appl(p) && (fun_sym(p) < s_proc_def))

#define pkind(p)        fun_sym(p)

#define is_delta(p)    ((p) && is_appl(p) && fun_sym(p) == a_delta)
#define is_tau(p)      ((p) && is_appl(p) && fun_sym(p) == a_tau)

#define is_semi(p)     ((p) && is_appl(p) && (fun_sym(p) == p_semi))
#define is_dot(p)      ((p) && is_appl(p) && (fun_sym(p) == p_dot))
#define is_star(p)     ((p) && is_appl(p) && (fun_sym(p) == p_star))
#define is_call(p)     ((p) && is_appl(p) && (fun_sym(p) == p_call))
#define is_plus(p)     ((p) && is_appl(p) && (fun_sym(p) == p_plus))
#define is_if(p)       ((p) && is_appl(p) && (fun_sym(p) == p_if))
#define is_fmerge(p)   ((p) && is_appl(p) && (fun_sym(p) == p_fmerge))
#define is_lmerge(p)   ((p) && is_appl(p) && (fun_sym(p) == p_lmerge))

#define left(p)        elm1(fun_args(p))
#define right(p)       elm2(fun_args(p))
#define proc_args(p)   fun_args(p)

extern proc *Delta;
extern proc *Tau;

typedef term ap_form;

/* ------------------ procdefs -------------------------------*/

typedef term proc_def;
typedef term proc_def_list;

proc_def  *mk_proc_def(char *, term_list *, term_list *, proc *);
#define pd_name(pd)    var_sym(elm1(fun_args(pd)))
#define pd_formals(pd)     elm2(fun_args(pd))
#define pd_vars(pd)        elm3(fun_args(pd))
#define pd_body(pd)        elm4(fun_args(pd))
#define is_proc_def(pd) ((pd) && is_appl(pd) && (fun_sym(pd) == s_proc_def))

void       pr_proc_def(proc_def *);


/* ---------------- timers -----------------------------------*/

#define mk_timer(at,dsym,dt,tsym,tt) \
          mk_appl3(p_timer, at, mk_appl1(dsym,dt), mk_appl1(tsym, tt))

#define timer_atom(tm)    elm1(fun_args(tm))
#define timer_delay(tm)   elm2(fun_args(tm))
#define timer_timeout(tm) elm3(fun_args(tm))

#define is_timer(tm)      ((tm) && (fun_sym(tm) == p_timer))


/* -------------- process instances ------------------------------ */

typedef term proc_inst;
typedef term proc_id;

#define mk_proc_inst(AP,Env,Subs,Notes,Name,Pid,Mon) \
                 mk_appl7(s_proc_inst, AP, Env, Subs, Notes, Name, Pid, Mon)

#define pi_alts(pi)   elm1(fun_args(pi))   /* < AP1 + ... + APn > */
#define pi_env(pi)    elm2(fun_args(pi))   /* local environment of process */
#define pi_subs(pi)   elm3(fun_args(pi))   /* list of subscriptions */
#define pi_notes(pi)  elm4(fun_args(pi))   /* list of notes */
#define pi_name(pi)   elm5(fun_args(pi))   /* name of proces definition (string) */
#define pi_pid(pi)    elm6(fun_args(pi))   /* process identifier (int) */
#define pi_mon(pi)    elm7(fun_args(pi))   /* monitor: NULL or mon(Tid), where
					      mon = logger | viewer | controller,
					      Tid is a tool identifier */

#define is_monitor(t) ((t) && is_appl(t) && ((fun_sym(t) == mon_logger) ||\
					     (fun_sym(t) == mon_viewer) ||\
					     (fun_sym(t) == mon_controller)))
void init_procs(void);
term_list *mk_functions(void);
void print_process(term *proc);
void print_process_snd_msgs_only(term *proc);
void print_alternatives(term *t, int snd_msgs_only);
void print_alternative(term *t, int snd_msgs_only);

#endif /* __PROCS_H__ */
