// Interval:  what you get if you subtract two timestamps.
// Last modified by DWF 1998-04-17

/*
    Copyright (C) 1998  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// All of XTide's time-related functions are only intended to be used
// within the minimal Unix epoch of years 1970 through 2037.

class Interval {
protected:

  // This representation will be adequate as long as the epoch limitation
  // is observed and time_t is the same size as a long.
  long seconds;

public:
  Interval ();
  Interval (long in_seconds);

  // Takes meridian string of the form [-]HH:MM
  Interval (const Dstr &in_meridian);

  // Output value in various units.
  long in_seconds () const;
  // Convert seconds to Julian centuries (36525 days)
  double in_Julian_centuries () const;
  // Return in the form [-]HH:MM:SS
  void as_hhmmss (Dstr &hhmmss_out);

  void operator -= (Interval a);
};

Angle operator* (Interval a, Speed b);
Angle operator* (Speed b, Interval a);
Interval operator* (Interval a, unsigned b);
Interval operator* (Interval a, double b);
Interval operator+ (Interval a, Interval b);
Interval operator- (Interval a, Interval b);
Interval abs (Interval a);
Interval operator- (Interval a);
int operator> (Interval a, Interval b);
int operator< (Interval a, Interval b);
int operator<= (Interval a, Interval b);
int operator== (Interval a, Interval b);
Interval operator/ (Interval a, int b);
double operator/ (Interval a, Interval b);
ostream &operator<< (ostream &out, Interval a);
