/* 
 * xwave - an interactive audio player, recorder, editor 
 * for the XWindow System
 * 
 * Copyright (C) 1996 Kai Kollmorgen
 * (kkollmor@informatik.uni-rostock.de)
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <dirent.h>

#include <X11/Xlib.h>		/* GC and other */
#include <X11/Intrinsic.h>	/* Intrinsics Definitions */
#include <X11/StringDefs.h>	/* Standard Name-String definitions */
#include <X11/Shell.h>
#include <X11/Xatom.h>

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

#include "types.h"
#include "xwave.h"
#include "menu.h"
#include "button.h"
#include "xwave_widget.h"
#include "misc.h"
#include "status.h"

static void setMainWindowName(Widget w, char *fname);

extern AppResources app_resources;
static Widget statwdgs[STAT_COUNT];

void create_status(Widget w)
{
    statwdgs[STAT_NAME]=MW ("st_name_label",labelWidgetClass,w,
			    XtNtop,XawChainTop,XtNbottom,XawChainTop,
			    XtNleft,XawChainLeft,XtNright,XawChainLeft,
			    XtNlabel,"",
			    XtNborderWidth,0,
			    NULL);
    
    statwdgs[STAT_RWMODE]=MW ("st_rwmode_label",labelWidgetClass,w,
			      XtNfromHoriz,statwdgs[STAT_NAME],
			      XtNtop,XawChainTop,XtNbottom,XawChainTop,
			      XtNleft,XawChainLeft,XtNright,XawChainLeft,
			      XtNlabel,"",
			      XtNborderWidth,0,
			      NULL);
    
    statwdgs[STAT_CHANGE]=MW ("st_modify_label",labelWidgetClass,w,
			      XtNfromHoriz,statwdgs[STAT_RWMODE],
			      XtNtop,XawChainTop,XtNbottom,XawChainTop,
			      XtNleft,XawChainLeft,XtNright,XawChainLeft,
			      XtNlabel,"",
			      XtNborderWidth,0,
			      NULL);
    
    statwdgs[STAT_CHANNEL]=MW ("st_chn_label",labelWidgetClass,w,
			       XtNfromHoriz,statwdgs[STAT_CHANGE],
			       XtNtop,XawChainBottom,XtNbottom,XawChainBottom,
			       XtNleft,XawChainLeft,XtNright,XawChainLeft,
			       XtNlabel,"",
			       XtNborderWidth,0,
			       NULL);
    
    statwdgs[STAT_RES]=MW ("st_res_label",labelWidgetClass,w,
			   XtNfromHoriz,statwdgs[STAT_CHANNEL],
			   XtNtop,XawChainBottom,XtNbottom,XawChainBottom,
			   XtNleft,XawChainLeft,XtNright,XawChainLeft,
			   XtNlabel,"",
			   XtNborderWidth,0,
			   NULL);
    
    statwdgs[STAT_FREQ]=MW ("st_freq_label",labelWidgetClass,w,
			    XtNfromHoriz,statwdgs[STAT_RES],
			    XtNtop,XawChainBottom,XtNbottom,XawChainBottom,
			    XtNleft,XawChainLeft,XtNright,XawChainLeft,
			    XtNlabel,"",
			    XtNborderWidth,0,
			    NULL);
    
    statwdgs[STAT_LENGTH]=MW ("st_length_label",labelWidgetClass,w,
			      XtNfromHoriz,statwdgs[STAT_FREQ],
			      XtNtop,XawChainBottom,XtNbottom,XawChainBottom,
			      XtNleft,XawChainLeft,XtNright,XawChainLeft,
			      XtNlabel,"",
			      XtNborderWidth,0,
			      NULL);
    
    statwdgs[STAT_TIME]=MW ("st_time_label",labelWidgetClass,w,
			    XtNfromHoriz,statwdgs[STAT_LENGTH],
			    XtNtop,XawChainBottom,XtNbottom,XawChainBottom,
			    XtNleft,XawChainLeft,XtNright,XawChainLeft,
			    XtNlabel,"",
			    XtNborderWidth,0,
			    NULL);
    
}

void update_status(Main_Data *md)
{
    char rwstring[]="RO";              /*                            */
    char chngstring[]="-";             /*                            */
    char chanstring[]="Stereo";        /*                            */
    char resstring[]="16 bit";         /* values are only examples   */
    char freqstring[]="44100 hz";      /* we overwrite them later    */
    float time;                        /*                            */
    char timestring[]="10000,00 kb";   /*                            */
    
    if (md->no==0) {
	set_beginmark_label(0);
	set_lengthmark_label(0);
	set_zoom_label(1);
	set_button_state(B_SAVE,B_ZDOWN,FALSE);
	set_button_state(B_REC,B_REC,md->mb->canplay);
	set_menu_state(M_SAVE,M_PROPS,False);
	XtVaSetValues(statwdgs[STAT_NAME],XtNlabel,"",NULL);
	XtVaSetValues(statwdgs[STAT_RWMODE],XtNlabel,"",NULL);
	XtVaSetValues(statwdgs[STAT_CHANGE],XtNlabel,"",NULL);
	XtVaSetValues(statwdgs[STAT_CHANNEL],XtNlabel,"",NULL);
	XtVaSetValues(statwdgs[STAT_RES],XtNlabel,"",NULL);
	XtVaSetValues(statwdgs[STAT_FREQ],XtNlabel,"",NULL);
	XtVaSetValues(statwdgs[STAT_LENGTH],XtNlabel,"",NULL);
	XtVaSetValues(statwdgs[STAT_TIME],XtNlabel,"",NULL);
	setMainWindowName(md->mw->form,NULL);
	return;
    }
    if (md->no==1) {
	set_button_state(B_BEG,B_ZDOWN,True);
	set_button_state(B_PLAY,B_REC,md->mb->canplay);
	set_menu_state(M_SAVEAS,M_CLOSE,True);
	set_menu_state(M_ECHO,M_PROPS,True);
	set_cmenu_state(CM_PLAY,CM_PLAY,md->mb->canplay);
	set_cmenu_state(CM_CLOSE,CM_CLOSE,True);
    }
    if (md->wd->ismark) {
	set_beginmark_label(md->wd->markbeg);
	set_lengthmark_label(md->wd->marklength);
	set_button_state(B_CUT,B_CUT,True);
	set_menu_state(M_CUT,M_COPY,True);
    } else {
	set_beginmark_label(0);
	set_lengthmark_label(0);
	set_button_state(B_CUT,B_CUT,False);
	set_menu_state(M_CUT,M_COPY,False);
    }
    
    if (md->wd->isplay) set_beginmark_label(md->wd->markbeg);
    
    set_menu_state(M_PASTE,M_PASTE,md->mb->isclip);
    
    if ((md->cb->modified)&&(md->cb->canwrite)) {
	set_button_state(B_SAVE,B_SAVE,True);
	set_menu_state(M_SAVE,M_SAVE,True);
    } else {
	set_button_state(B_SAVE,B_SAVE,False);
	set_menu_state(M_SAVE,M_SAVE,False);
    }
    set_zoom_label(md->cg->step);
    
    if (md->wd->channels>1) set_menu_state(M_SWAP,M_SWAP,True);
    else set_menu_state(M_SWAP,M_SWAP,False);
    
    short_fname(statwdgs[STAT_NAME],md->wd->name);
    if (md->cb->canwrite) strcpy(rwstring,"RW");
    XtVaSetValues(statwdgs[STAT_RWMODE],XtNlabel,rwstring,NULL);
    if (md->cb->modified) strcpy(chngstring,"m");
    XtVaSetValues(statwdgs[STAT_CHANGE],XtNlabel,chngstring,NULL);
    if (md->wd->channels==MONO) strcpy(chanstring,"Mono");
    XtVaSetValues(statwdgs[STAT_CHANNEL],XtNlabel,chanstring,NULL);
    if (md->wd->res==8) strcpy(resstring,"8 bit");
    XtVaSetValues(statwdgs[STAT_RES],XtNlabel,resstring,NULL);
    sprintf(freqstring,"%i hz",md->wd->freq);
    XtVaSetValues(statwdgs[STAT_FREQ],XtNlabel,freqstring,NULL);
    time=(float)md->wd->length/(float)1024; /* 1kb */
    sprintf(timestring,"%.2f kb",time);
    XtVaSetValues(statwdgs[STAT_LENGTH],XtNlabel,timestring,NULL);
    time=(float)md->wd->tlength/(float)md->wd->freq;
    sprintf(timestring,"%.2f s",time);
    XtVaSetValues(statwdgs[STAT_TIME],XtNlabel,timestring,NULL);
    
    setMainWindowName(md->mw->form,md->wd->name);
}

void setMainWindowName(Widget w, char *fname)
{
    char *windowname;
    int length;
    
    
    length=strlen("xwave v")+strlen(VERSION)+strlen(" : ");
    if (fname==NULL) 
      length+=strlen("No file")+1;
    else
      length+=strlen(fname)+1;
    length+=strlen(app_resources.device)+3;
    windowname=malloc(length);
    strcpy(windowname,"xwave v");
    strcat(windowname,VERSION);
    strcat(windowname," : ");
    if (fname==NULL) 
      strcat(windowname,"No file");
    else
      strcat(windowname,fname);
    strcat(windowname," [");
    strcat(windowname,app_resources.device);
    strcat(windowname,"]");
    setWmWindowName(w, windowname);
    free(windowname);
}
