
#ifndef FALSE
#define FALSE 0
#endif

#ifndef False
#define False 0
#endif

#ifndef TRUE
#define TRUE 1
#endif

#ifndef True
#define True 1
#endif

#define AF_OPEN O_RDONLY
#define AF_NEW (O_RDWR | O_CREAT | O_TRUNC)

#define AF_ERROR -1
#define AF_RIFF 0
#define AF_AIFC 1
#define AF_AU 2
#define AF_RAW 3
#define AF_NOTSUPPORTED 4
#define AF_UNKNOWN 5
#define AF_UNDEFINED 6
#define AF_NORAW 7

#define AF_PCM 0
#define AF_ALAW 1
#define AF_MULAW 2

#define PCM_STRING "PCM"
#define ALAW_STRING "ALAW"
#define MULAW_STRING "ULAW"

#define RIFF_STRING "RIFF"
#define AIFC_STRING "AIFC"
#define AIFF_STRING "AIFF"
#define AU_STRING "AU"

typedef unsigned char byte;
typedef byte bool;

typedef struct { 
   int fd;
   byte bps;
   byte channels;
   ulong comp;
   ulong type;
   int freq;
   int length;
   int headoffs;
} Audio_File;



int af_open(char *name,Audio_File *af,int mode);
int af_read(Audio_File af,char *buffer,int size);
int af_write(Audio_File af,char *buffer,int size);
char *af_info(char *name,short *af_type);
int af_seek(Audio_File af,int pos,int mode);
int af_close(Audio_File af);
int af_rewind(Audio_File af);

	    
