/*------------------------------------------------------------------------------
*
* Copyright (c) 2011-2018, EURid vzw. All rights reserved.
* The YADIFA TM software product is provided under the BSD 3-clause license:
* 
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions
* are met:
*
*        * Redistributions of source code must retain the above copyright 
*          notice, this list of conditions and the following disclaimer.
*        * Redistributions in binary form must reproduce the above copyright 
*          notice, this list of conditions and the following disclaimer in the 
*          documentation and/or other materials provided with the distribution.
*        * Neither the name of EURid nor the names of its contributors may be 
*          used to endorse or promote products derived from this software 
*          without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
* ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
* SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
* CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
*
*------------------------------------------------------------------------------
*
*/
/** @defgroup error dnssec
 *  @ingroup dnscore
 *  @brief DNSSEC error codes
 *
 * @{
 */

#ifndef _DNSSEC_ERROR_H
#define	_DNSSEC_ERROR_H

#define DNSSEC_ERROR_BASE		        0x80050000
#define DNSSEC_ERROR_CODE(code_)	    ((s32)(DNSSEC_ERROR_BASE+(code_)))
    
#define DNSSEC_ERROR_NOENGINE			DNSSEC_ERROR_CODE(  1)
#define DNSSEC_ERROR_INVALIDENGINE		DNSSEC_ERROR_CODE(  2)
#define DNSSEC_ERROR_CANTPOOLTHREAD		DNSSEC_ERROR_CODE(  4)

#define DNSSEC_ERROR_UNSUPPORTEDKEYALGORITHM	DNSSEC_ERROR_CODE( 10)
#define DNSSEC_ERROR_UNSUPPORTEDDIGESTALGORITHM	DNSSEC_ERROR_CODE( 11)

#define DNSSEC_ERROR_DUPLICATEKEY		DNSSEC_ERROR_CODE( 64)
#define DNSSEC_ERROR_INCOMPLETEKEY		DNSSEC_ERROR_CODE( 65)
#define DNSSEC_ERROR_KEYSTOREPATHISTOOLONG	DNSSEC_ERROR_CODE( 66)
#define DNSSEC_ERROR_UNABLETOCREATEKEYFILES	DNSSEC_ERROR_CODE( 67)
#define DNSSEC_ERROR_KEYWRITEERROR		DNSSEC_ERROR_CODE( 68)
#define DNSSEC_ERROR_BNISNULL	    		DNSSEC_ERROR_CODE( 69)
#define DNSSEC_ERROR_BNISBIGGERTHANBUFFER	DNSSEC_ERROR_CODE( 70)
#define DNSSEC_ERROR_UNEXPECTEDKEYSIZE		DNSSEC_ERROR_CODE( 71)
#define DNSSEC_ERROR_KEYISTOOBIG		DNSSEC_ERROR_CODE( 72)
#define DNSSEC_ERROR_KEYRING_ALGOTAG_COLLISION  DNSSEC_ERROR_CODE( 73)
#define DNSSEC_ERROR_KEYRING_KEY_IS_INVALID     DNSSEC_ERROR_CODE( 74)

#define DNSSEC_ERROR_RSASIGNATUREFAILED		DNSSEC_ERROR_CODE(128)
#define DNSSEC_ERROR_DSASIGNATUREFAILED		DNSSEC_ERROR_CODE(129)
#define DNSSEC_ERROR_ECDSASIGNATUREFAILED	DNSSEC_ERROR_CODE(130)

#define DNSSEC_ERROR_NSEC3_INVALIDZONESTATE	DNSSEC_ERROR_CODE(256)
#define DNSSEC_ERROR_NSEC3_LABELTODIGESTFAILED	DNSSEC_ERROR_CODE(257)
#define DNSSEC_ERROR_NSEC3_DIGESTORIGINOVERFLOW	DNSSEC_ERROR_CODE(258)

#define DNSSEC_ERROR_NSEC_INVALIDZONESTATE	DNSSEC_ERROR_CODE(384)

#define DNSSEC_ERROR_RRSIG_NOENGINE		DNSSEC_ERROR_CODE(512)
#define DNSSEC_ERROR_RRSIG_NOZONEKEYS		DNSSEC_ERROR_CODE(513)
#define DNSSEC_ERROR_RRSIG_NOUSABLEKEYS		DNSSEC_ERROR_CODE(514)
#define DNSSEC_ERROR_RRSIG_NOSOA		DNSSEC_ERROR_CODE(515)
#define DNSSEC_ERROR_RRSIG_NOSIGNINGKEY		DNSSEC_ERROR_CODE(516)
#define DNSSEC_ERROR_RRSIG_UNSUPPORTEDRECORD	DNSSEC_ERROR_CODE(517)

#endif // _DNSSEC_ERROR_H
