#include <guile/gh.h>

#include <dirent.h>
#include <sys/stat.h>

#include <uc++/plugin.h>

#include "guile-loader.h"
#include "guile-script.h"

using namespace SigC;

namespace uC
{

class guilePlugin : public Plugin
{
  public:
    guilePlugin(PluginManager *mgr, SCM sobj) : Plugin(mgr) { }

    virtual std::string description() const {
      return "<uC++ guile plugin #XXXXX>";
    }
};

guilePluginLoader::guilePluginLoader(PluginManager *mgr)
    : PluginLoader(mgr), Plugin(mgr)
{
}

guilePluginLoader::~guilePluginLoader()
{
}

Plugin *guilePluginLoader::load(PluginManager *mgr, const std::string& name)
{
  // remove "guile." prefix
  if (name.substr(0, 7) != "guile.")
    return 0;
  std::string realname = std::string("guile/") + name.substr(7) + ".scm";

  // get language object
  Script::Language *lang = mgr->language("guile");
  
  if (!lang)
    return 0;

  std::list<std::string>::const_iterator it;
  const std::list<std::string>& indep_paths = mgr->arch_indep_paths();
  
  SCM splugin = SCM_UNDEFINED;
  
  for (it = indep_paths.begin(); it != indep_paths.end(); ++it)
  {
    typedef SCM (*scmcfunc)(const char *);
    
    struct stat st;
    if (stat(((*it) + realname).c_str(), &st) == 0)
    {
      splugin = pack<SCM, const char *>(slot((scmcfunc)&gh_eval_file), 
					((*it) + realname).c_str())
	->tunnel(lang->tunnel(), true);
      
      if (splugin != SCM_UNDEFINED)
	return manage(new guilePlugin(mgr, splugin));
    }
  }
  
  return 0;
}

namespace
{

void do_scan(PluginManager *mgr, const std::string& path, 
             const std::string& basename)
{
  DIR *dir;
  struct dirent *file;

  if ((dir = opendir(path.c_str())) != NULL)
  {
    while ((file = readdir(dir)) != NULL)
    {
      int len;
      std::string fullname = path + file->d_name;
      struct stat statinfo;
      
      if (file->d_name[0] != '.' &&
          stat(fullname.c_str(), &statinfo) == 0 && S_ISDIR(statinfo.st_mode))
        do_scan(mgr,
                path + file->d_name + "/", basename + file->d_name + ".");
      
      len = strlen(file->d_name);
      if (len > 3 && strcmp(file->d_name + len - 3, ".scm") == 0)
        mgr->plugin_found(basename + 
                          std::string(file->d_name).substr(0, len - 4));
    }
  }
}

}

void guilePluginLoader::scan(PluginManager *mgr) const
{
  const std::list<std::string>& paths = mgr->arch_indep_paths();
  std::list<std::string>::const_iterator it;

  for (it = paths.begin(); it != paths.end(); ++it)
    do_scan(mgr, (*it) + "/guile/", "guile.");
}

}
