/* -*- c++ -*-

  SigC++ cross-thread signalling support.
   
  Copyright 2000 Andreas Rottmannn <rottmann@users.sourceforge.net>
                                                         
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
 
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef SIGCXX_THREAD_TUNNEL_H
#define SIGCXX_THREAD_TUNNEL_H

#include <stdexcept>
#include <list>

#include <sigc++/thread.h>
#include <sigc++/tunnel.h>
#include <sigc++/dispatch.h>

#ifdef SIGC_CXX_NAMESPACES
namespace SigC
{
#endif

class ThreadTunnel : public Tunnel
{
  public:
    ThreadTunnel(Dispatcher *disp, bool multithreaded = true);
    virtual ~ThreadTunnel();
    
    Dispatcher *dispatcher() { return(disp_); }

    virtual void send(Callback *cb, bool sync = false);
    
    class FatalError : public runtime_error
    {
      public:
        FatalError(int e);
        virtual ~FatalError() throw() { }
	
        virtual const char *what() const throw() { return(what_.c_str()); }
      private:
        string what_;
#if defined(SIGC_PTHREADS) && !defined(HAVE_STRERROR_R) && !defined(HAVE___STRERROR_R)
        Threads::Mutex mutex_;
#endif
    };
  private:
    class InputHandler : public Dispatcher::Handler
    {
      public:
        InputHandler(ThreadTunnel *tunnel) : tunnel_(tunnel) { }
        virtual void callback(Dispatcher *, Event);
      private:
        ThreadTunnel *tunnel_;
    };
    friend class InputHandler;

    struct Packet
    {
        Callback *callback;
        bool sync;
    };

    void send_packet(const Packet& packet);
    void receive_packet(Packet& packet);

    Dispatcher *disp_;
    Dispatcher::Handler *input_cb_;
    int pipe_[2];
    bool multi_threaded_;
    int pending_;
    
    static list<Tunnel *> *tunnels_;
    static void sync_tunnels();
    
#ifdef SIGC_PTHREADS
    Threads::Mutex mutex_;
    Threads::Condition cb_finished_;
#endif
};

#ifdef SIGC_CXX_NAMESPACES
} // namespace
#endif
 
#endif
