package Zim::GUI::ExportDialog;

use strict;
use File::BaseDir qw/xdg_data_files xdg_data_dirs xdg_data_home/;
use Gtk2;

our $VERSION = '0.17';

=head1 NAME

Zim::GUI::ExportDialog - dialog for zim

=head1 DESCRIPTION

This modules contains the export dialog for zim.
It is autoloaded when needed.

=head1 METHODS

=over 4

=item C<new()>

Simple constructor

=cut

sub new {
	my ($class, %self) = @_;
	bless \%self, $class;
}

=item C<show()>

Present the dialog.

=cut

sub show {
	my $self = shift;
	return $self->{dialog}->present if defined $self->{dialog};
	$self->{app}->save_page || return;

	my $dialog = Gtk2::Dialog->new(
		"Export page - Zim", $self->{app}{window},
	       	[qw/destroy-with-parent no-separator/],
		'gtk-help'   => 'help',
		'gtk-cancel' => 'cancel',
		'gtk-ok'     => 'ok',
	);
	$dialog->set_resizable(0);
	$dialog->vbox->set_border_width(12);
	
	# Page range
	my $frame = Gtk2::Frame->new;
	my $label = Gtk2::Label->new('<b>Pages</b>');
	$label->set_use_markup(1);
	$frame->set_label_widget($label);
	$dialog->vbox->add($frame);
	
	my $vbox = Gtk2::VBox->new(0, 5);
	$vbox->set_border_width(12);
	$frame->add($vbox);
	
	my $radio1 = Gtk2::RadioButton->new_with_mnemonic(undef, '_All');
	my $rgroup = $radio1->get_group;
	$vbox->add($radio1);

	my $hbox = Gtk2::HBox->new(0, 5);
	$vbox->add($hbox);
	
	my $radio2 = Gtk2::RadioButton->new_with_mnemonic($rgroup, '_Page:');
	$hbox->pack_start($radio2, 0,1,0);
	
	my $page_entry = Gtk2::Entry->new();
	$page_entry->set_text( $self->{app}{page}->name );
	$page_entry->set_sensitive(0);
	$hbox->pack_start($page_entry, 0,1,0);

	my $recurs_box = Gtk2::CheckButton->new_with_label('Recursive');
	$recurs_box->set_active(1);
	$recurs_box->set_sensitive(0);	
	$vbox->add($recurs_box);
	
	$radio2->signal_connect( toggled => sub {
		my $active = $radio2->get_active;
		$page_entry->set_sensitive( $active );
		$recurs_box->set_sensitive( $active );
	} );
	
	# Output
	$frame = Gtk2::Frame->new;
	$label = Gtk2::Label->new('<b>Output</b>');
	$label->set_use_markup(1);
	$frame->set_label_widget($label);
	$dialog->vbox->add($frame);
	
	my $table = Gtk2::Table->new(5, 3);
	$table->set_border_width(12);
	$table->set_row_spacings(5);
	$table->set_col_spacings(12);
	$frame->add($table);
	
	my $i;
	for (qw/Format Template/, '', 'Output dir') {
		if (length $_) {
			my $label = Gtk2::Label->new($_.':');
			my $align = Gtk2::Alignment->new(0,0.5, 0,0);
			$align->add($label);
			$table->attach_defaults($align, 0,1, $i,$i+1);
		}
		$i++;
	}

	my $conf = $self->{app}{repository}->config;
	my ($template, $dir) = @$conf{'export_template', 'export_dir'};
	# TODO actually use $template
	
	my $combo1 = Gtk2::ComboBox->new_text();
	$combo1->append_text('Html');
	$combo1->set_active(0);
	$combo1->set_sensitive(0);
	$table->attach_defaults($combo1, 1,2, 0,1);
	
	my $combo2 = Gtk2::ComboBox->new_text();
	my $templates = Zim::Repository->list_templates('html');
	my @templates = sort keys %$templates;
	$combo2->append_text($_) for @templates;
	$combo2->append_text('other...');
	my ($default) = grep {$templates[$_] =~ /plain/i} 0 .. $#templates;
	$combo2->set_active($default);
	$table->attach_defaults($combo2, 1,2, 1,2);
	
	my $entry2 = Gtk2::Entry->new;
	$entry2->set_sensitive(@templates == 0);
	$table->attach_defaults($entry2, 1,2, 2,3);
	my $button2 = Gtk2::Button->new('_Browse...');
	$button2->set_sensitive(@templates == 0);
	$button2->signal_connect(clicked => sub {
		my $t = $self->{app}->filechooser_dialog();
		$entry2->set_text($t);
	} );
	$table->attach_defaults($button2, 2,3, 2,3);

	my $entry3 = Gtk2::Entry->new;
	$table->attach_defaults($entry3, 1,2, 3,4);
	$entry3->set_text($dir);
	$entry3->signal_connect(activate => sub { $dialog->response('ok') });
	my $button3 = Gtk2::Button->new('_Browse...');
	$button3->signal_connect(clicked => sub {
		$dir = $self->{app}->filechooser_dialog($dir, 'DIR');
		$entry3->set_text($dir);
	} );
	$table->attach_defaults($button3, 2,3, 3,4);
	
	$combo2->signal_connect(changed => sub {
		my $active = ($combo2->get_active > $#templates) ;
		$entry2->set_sensitive($active);
		$button2->set_sensitive($active);
	} );

	$frame = Gtk2::Frame->new;
	$label = Gtk2::Label->new('<b>Media</b>');
	$label->set_use_markup(1);
	$frame->set_label_widget($label);
	$dialog->vbox->add($frame);
	
	$vbox = Gtk2::VBox->new(0, 5);
	$vbox->set_border_width(12);
	$frame->add($vbox);
	
	my $media_radio1 = Gtk2::RadioButton->new_with_mnemonic(undef, '_Relative linked');
	$rgroup = $media_radio1->get_group;
	$vbox->add($media_radio1);

	my $media_radio2 = Gtk2::RadioButton->new_with_mnemonic($rgroup, '_Absolute linked');
	$vbox->add($media_radio2);

#	my $media_radio3 = Gtk2::RadioButton->new_with_mnemonic($rgroup, '_Copy files');
#	$vbox->add($media_radio3);

	# Run dialog
	$self->{dialog} = $dialog;
	$dialog->show_all;
	while ($_ = $dialog->run) {
		if ($_ eq 'help') {
			$self->{app}->ShowHelp(':zim:usage:exporting');
			next;
		}
		
		last unless $_ eq 'ok';
		
		# TODO, resolve page here !
		# and resolve page in zim.pl sub export
		my @pages = $radio1->get_active ? (':') : (
			grep length($_),
			split /,\s*|\s+/, $page_entry->get_text ) ;
		last unless @pages;
		
		my $template;
		if ($entry2->is_sensitive) { $template = $entry2->get_text }
		else {
			my $key = $templates[ $combo2->get_active ];
			$template = $$templates{$key};
		}

		my $media =
			$media_radio2->get_active ? 'absolute' : 'relative' ;
			#$media_radio3->get_active ? 'copy'     : 'relative' ;

		my %opts = (
			format   => 'html',
			root     => $entry3->get_text,
			template => $template,
			media    => $media,
		);
		$$conf{export_dir} = $opts{root};
		$dialog->destroy;
		$self->{dialog} = undef;
		my ($bar, $label);
		($dialog, $bar, $label) = $self->{app}->_new_progress_bar(
			"Export page - Zim", "Exporting page 1" );
		my $continue = 1;
		$dialog->signal_connect(response => sub {$continue = 0});
		my $i = 1;
		$opts{callback} = sub {
			$bar->pulse;
			$label->set_text('Exporting page ' . $i++);
			while (Gtk2->events_pending) { Gtk2->main_iteration_do(0) }
			return $continue;
		};
		
		eval {
			my $o = { resolve => 1, recurse => $recurs_box->get_active() };
			my $s = $self->{app}{repository}->get_selection($o, @pages);
			$s->export(\%opts);
		};
		$self->{app}->error_dialog($@) if $@;
		
		last;
	}
	$dialog->destroy;
	$self->{dialog} = undef;
}

=item C<hide()>

Delete the dialog.

=cut

sub hide {
	return unless $_[0]->{dialog};
	$_[0]->{dialog}->destroy;
	$_[0]->{dialog} = undef;
}

1;

__END__

=back

=head1 AUTHOR

Jaap Karssenberg (Pardus) E<lt>pardus@cpan.orgE<gt>

Copyright (c) 2006 Jaap G Karssenberg. All rights reserved.
This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

=cut

