/* modifytest.c - part of ziproxy package
 *  Copyright (c)2002 Juraj Variny <variny@anex.sk>
 *  
 *  Released subject to GNU General Public License v2 or later version
 *
 *  Test of HTML modification. It reads _entire_ standard input first, then does 
 *  modification and prints modified output to standard output.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>

#include "htmlmodify.h"

int main()
{
		char* buf, *outb;
		int ch,len=4096,pos=0;
		buf=malloc(len);

		while((ch=getchar())!=EOF)
		{
				if (pos + 1 >= len)
						buf = realloc(buf,(len*=2) + 1);
				buf[pos++] = ch;
		}
		
		buf[pos]='\0';
		
		htmlmodify(buf, &outb, 0);
		fwrite(outb,strlen(outb),1,stdout);
		return 0;
}
