/* genembbin.c
 * Part of ziproxy package
 *
 * Copyright (c)2005-2010 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * Generates a C-source include with data from binary files
 * This is a standalone code and not included in main Ziproxy executable.
 */

#include <stdio.h>
#include <stdlib.h>

/* returns null if unsuccessful (or file is empty), otherwise:
 * pointed buffer must be freed after usage
 * returns data pointer into *filesize, if filesize != NULL
 * updates *file_size with the total bytes of it
/* FIXME: this routine does not expect IO errors */
char *load_binfile_to_memory (const char *given_filename, int *file_size)
{
	int my_filesize;
	char *my_buff;
	FILE *my_file;

	if ((my_file = fopen (given_filename, "rb")) != NULL) {
		/* determine file size */
		fseek (my_file, 0, SEEK_END);
		my_filesize = ftell (my_file);
		fseek (my_file, 0, SEEK_SET);
		//if (my_filesize = 0)
		//	return (NULL);

		if ((my_buff = malloc (my_filesize)) != NULL) {
			fread (my_buff, my_filesize, 1, my_file);
			fclose (my_file);
			*file_size = my_filesize;
			return (my_buff);
		} else {
			fclose (my_file);
		}
	}

	return (NULL);
}

void genembbin_fromfile (const char *table_name, const char *file_name)
{
	int file_size;
	char *file_buff;
	int i;

	if ((file_buff = load_binfile_to_memory (file_name, &file_size)) != NULL) {
		printf ("#define %s_size %d\n\n", table_name, file_size);
		printf ("const char %s [%d] = {\n", table_name, file_size);
		printf ("\t");
		for (i = 0; i < file_size; i++) {
			printf ("%d", file_buff [i]);
			if (i < (file_size - 1))
			printf (", ");
		}
		printf ("\n");
		printf ("};\n\n");
		free (file_buff);
	} else {
		fprintf (stderr, "ERROR: Unable to load input file: %s\n\n", file_name);
	}
}

main ()
{
	printf ("/* embbin.c\n"
		" * Part of ziproxy package\n"
		" * \n"
		" * Copyright (c)2005-2010 Daniel Mealha Cabrita\n"
		" *\n"
		" * Released subject to GNU General Public License v2 or later version.\n"
		" *\n"
		" * Embedded binaries' tables\n"
		" *\n"
		" * *** Do not edit this file directly, it was generated by genembbin.c\n"
		" * *** genembbin is not invoked neither compiled by make,\n"
	        " * *** thus it should be compiled and executed manually.\n"
		" */\n"
		"\n\n");
	printf ("//To stop multiple inclusions.\n"
		"#ifndef EMBBIN_H\n"
		"#define EMBBIN_H\n"
		"\n");

	genembbin_fromfile ("embbin_empty_image", "embbin/empty_image.gif");
	
	printf ("\n"
		"#endif\n"
		"\n");
}
