/* strtables.h
 * Part of ziproxy package
 *
 * Copyright (c)2005-2010 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * Auxiliary routines for list generation and list lookup
 */

//To stop multiple inclusions.
#ifndef SRC_STRTABLES_H
#define SRC_STRTABLES_H

// private
/* for strings without meta-characters '*' */
typedef struct {
	int total_entries;
	int *hashes_tab;	// contains the pseudo-hashes. when a expression contain a '*', this data is meaningless
	char **exp_tab;	// array of pointers to expressions
	char *exp_data;	// the expressions themselves
	int exp_data_len; // in chars
} t_st_strtable_nometa;

// private
/* for strings with meta-characters '*' */
typedef struct {
	int total_entries;
	char **exp_tab;	// array of pointers to expressions
	char *exp_data;	// the expressions themselves
	int exp_data_len; // in chars
	int largest_len;  // the total of chars of the largest entry
} t_st_strtable_meta;

// private
typedef struct {
	t_st_strtable_nometa nometa;
	t_st_strtable_meta meta;
} t_st_strtable;


extern t_st_strtable *st_create (void);
extern void st_destroy (t_st_strtable *st_strtable);
extern void st_insert (t_st_strtable *st_strtable, const char *strexp);
extern void st_insert_nometa (t_st_strtable *st_strtable, const char *strexp);
extern int st_check_if_matches_nometa (const t_st_strtable *st_strtable, const char *strdata);
extern int st_check_if_matches_meta (const t_st_strtable *st_strtable, const char *strdata);
extern int st_check_if_matches (const t_st_strtable *st_strtable, const char *strdata);

// for testing purposes only
/*
extern void st_dump_strings (t_st_strtable *st_strtable);
*/

#endif

