/* text.c - part of ziproxy package
 *
 * Copyright (c)2003-2004 Juraj Variny<variny@naex.sk>
 * Copyright (c)2005-2010 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * HTML modification, text compression fuctions
 */

#include "http.h"

//To stop multiple inclusions.
#ifndef SRC_TEXT_H
#define SRC_TEXT_H

extern int do_compress_stream_stream (http_headers *hdr, FILE *from, FILE *to, ZP_DATASIZE_TYPE *inlen, ZP_DATASIZE_TYPE *outlen);
extern int do_decompress_stream_stream (http_headers *hdr, FILE *from, FILE *to, ZP_DATASIZE_TYPE *inlen, ZP_DATASIZE_TYPE *outlen, int max_ratio, ZP_DATASIZE_TYPE min_eval);
extern int do_compress_memory_stream (http_headers *hdr, const char *from, FILE *to, const ZP_DATASIZE_TYPE inlen, ZP_DATASIZE_TYPE *outlen);
extern ZP_DATASIZE_TYPE replace_gzipped_with_gunzipped (char **inoutbuf, ZP_DATASIZE_TYPE inlen, ZP_DATASIZE_TYPE max_growth);
enum {ONormal, OChunked, OStream, OGzipStream};

#endif //SRC_TEXT_H
