# Copyright 1999-2005 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /cvsroot/znc/znc/znc-0.000.ebuild,v 1.12 2006/02/19 10:21:36 prozacx Exp $

inherit eutils

DESCRIPTION="znc - Advanced IRC Bouncer"
HOMEPAGE="http://znc.sourceforge.net"
SRC_URI="mirror://sourceforge/${PN}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="x86 amd64 ~sparc"
IUSE="ssl ipv6 nomodules debug"
RESTRICT="nostrip"

RDEPEND="virtual/libc"
DEPEND="virtual/libc
		>=sys-devel/gcc-3.2.3-r4
		ssl? ( >=dev-libs/openssl-0.9.7d )"

src_unpack() {
	unpack ${A} || die "unpack failed"
}

src_compile() {
	local MY_CONFARGS=""

	use ssl || MY_CONFARGS="${MY_CONFARGS} --disable-openssl"
	use ipv6 && MY_CONFARGS="${MY_CONFARGS} --enable-ipv6"
	use nomodules && MY_CONFARGS="${MY_CONFARGS} --disable-modules"
	use debug && MY_CONFARGS="${MY_CONFARGS} --enable-debug"

	econf ${MY_CONFARGS} || die "econf failed"
	emake CFLAGS="${CFLAGS}" || die "emake failed"
}

src_install() {
	make install DESTDIR=${D}
	dodoc docs/*.html || die "dodoc failed"
	dodoc AUTHORS znc.conf || die "dodoc failed"
}

pkg_postinst() {
	einfo "You can browse the documentation here:"
	einfo "    /usr/share/doc/${PF}/*.html.gz"
	einfo "Also check out the online documentation at:"
	einfo "    http://znc.sourceforge.net"
	einfo " "
	einfo "You can find an example znc.conf file here:"
	einfo "    /usr/share/doc/${PF}/znc.conf.gz"
	einfo " "
}
