##########################################################################
#                                                                        #
#           copyright (c) 2003 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Booklet reference class"""

from AccessControl import ClassSecurityInfo
from Products.CMFCore.permissions import View
from Products.Archetypes.public import Schema
from Products.Archetypes.public import StringField, StringWidget
from Products.Archetypes.public import registerType

from Products.CMFBibliographyAT.content.base import BaseEntry
from Products.CMFBibliographyAT.content.schemata \
    import HeaderSchema, AuthorSchema, CoreSchema, TrailingSchema
from Products.CMFBibliographyAT.content.fields import howpublishedField


howpublishedspecificField = howpublishedField.copy()
howpublishedspecificField.default = 'Booklet'
SourceSchema = Schema((
    howpublishedspecificField,
    ))

BookletSchema = HeaderSchema + AuthorSchema + CoreSchema +  \
                SourceSchema + TrailingSchema


class BookletReference(BaseEntry):
    """ content type to make reference to a booklet (a book without publisher).
    """
    security = ClassSecurityInfo()
    archetype_name = "Booklet Reference"
    source_fields = ('howpublished',)

    schema = BookletSchema

    security.declareProtected(View, 'Source')
    def Source(self):
        """ the default booklet source format
        """
        try:
            return self.BookletSource()
        except AttributeError:
            return "Booklet."


registerType(BookletReference)
