try:
    from Interface import Interface
except ImportError:
    # for Zope versions before 2.6.0
    from Interface import Base as Interface

try:
    from Products.CMFPlone import utils as plone_utils
except ImportError:
    from Products.CMFPlone import PloneUtilities as plone_utils

from Products.Archetypes.utils import shasattr

class IMember(Interface):
    """
    User object integration. Contract w/CMF regarding Member object
    behavior. A Member is a wrapped user object.
    """
    
    def getPassword():
        """ Gets the password for a Member. """
        pass
        
    def getRawGroups():
        """ Fetches the Group names from GRUF with prefix. """
        pass
        
    def getRoles():
        """ Return the list of roles assigned to a Member. """
        pass
        
    def setRoles(roles):
        """ Assign a set of roles to a Member. """
        pass
        
    def getRolesInContext(object):
        """ 
        Return the list of roles assigned to a Member
        in the context of an object. 
        """
        pass
    
    def getUser():
        """ Return the user object associated with the Member. """
        pass
        
    def getUserName():
        """ Gets the Member object, then return the username of the Member. """
        pass
        
    def hasUser():
        """
        Returns 1 if there is a real acl_users user associated with
        this Member, 0 if there is a temporary internal one.
        """
        pass
        
    def has_role(roles, object=None):
        """ 
        Check to see if a user has a given role or roles. 
        Passing an object examines the Local Roles on that object.
        """
        pass
        
    def isOrphan():
        """ Returns 1 if a Member has been orphaned and 0 if not. """
        pass
        
    def setGroups(groups):
        """ Assigns the groups to the Member using GRoupUserFolder. """
        pass
        
    def getGroups():
        """ Returns the groups from GRUF. """
        pass
        
    def setMemberProperties(props):
        """ 
        Assigns keyword arguments as properties of a Member for
        compatibility to CMFCore Member handling.
        """
        pass
        
    def setUser(user):
        """ Set the Member's user object. """
        pass
    
    def setDomains(domains):
        """ Sets domain restrictions in the Security Profile of a Member. """
        pass
        
    def getDomains():
        """ Return the list of domain restrictions for a Member. """
        pass
    
    def valid_groups():
        """ Returns a list of valid groups from GRUF. """
        pass
        
    def valid_roles():
        """ Returns a list of valid roles for Members. """
        pass
        
    def getEmail():
        """ Returns the email address of a Member. """
        pass
        
    def getLast_login_time():
        """ Returns the time the Member last logged into the system. """
        pass
        
    def setLast_login_time(last_login_time):
        """ Sets the time of the most recent login. """
        pass

    def getMemberId():
        """ Returns the Id of the Member. """
        pass
        
    def setSecurityProfile(password=None, roles=None, domains=None):
        """ Sets the security profile attributes of the Member. """
        pass
        
    def getId():
        """ Accessor for the ID field of a Member. """
        pass
        
    def getProperty(id, default):
        """ Return user property by using the accessor for the property. """
        pass
            
class IMemberPlone(Interface):
    """
      Contract with Plone (i.e. in addition to IMember) regarding Member object.
      These are the default fields for a Plone Member.
    """
    def getFullname():
        """ Accessor for the fullname field. """
        pass
        
    def setFullname(fullname):
        """ Mutator for the fullname field. """
        pass
 
    def getVisible_ids():
        """ Accessor for the visible_ids field. """
        pass
        
    def setVisible_ids(visible_ids):
        """ Mutator for the visible_ids field. """
        pass
        
    def getWysiwyg_editor():
        """ Accessor for the WYSIWYG editor field. """
        pass
        
    def setWysiwyg_editor(editor):
        """ Mutator for the WYSIWYG editor field. """
        pass
        
    def getPortrait():
        """ Accessor for the portrait field. """
        pass
        
    def setPortrait(portraitfile):
        """ Mutator for the portrait field. """
        pass

    if shasattr(plone_utils, 'getFSVersionTuple') and \
       plone_utils.getFSVersionTuple >= (2, 1):
        
        def getHome_page():
            """ Accessor for the home_page field """
            pass

        def setHome_page(home_page):
            """ Mutator for the home_page field """
            pass

        def getLocation():
            """ Accessor for the location field """
            pass

        def setLocation(home_page):
            """ Mutator for the location field """
            pass

        def getLanguage(home_page):
            """ Accessor for the language field """
            pass

        def setLanguage(home_page):
            """ Mutator for the language field """
            pass
