import sys, os
from zLOG import LOG, PROBLEM, DEBUG, ERROR

try:
    dummy=True
except NameError:
    True=1
    False=0

def findPIL():
    """ try to find PIL
    """
    try:
         import PIL.Image
         LOG('CMFPhoto', DEBUG, 'PIL found', 'The Python Imaging Library \
was found at %s.' % PIL.__path__[0])
         return True
    except ImportError, err:
        LOG('CMFPhoto', PROBLEM, 'PIL not found', 'The Python Imaging Library \
(http://www.pythonware.com/products/pil/) was not found.')
        return False

def findConvert():
    """try to find the convert utility in the search path
    """
    if sys.platform == 'win32':
        convert = 'convert.exe'
    else:
        convert = 'convert'

    envPath = os.environ['PATH']
    syspath = [p for p in envPath.split(os.pathsep) ]
    for path in syspath:
        if os.path.isdir(path):
            if convert in [ entry.lower() for entry in os.listdir(path) ]:
                LOG('CMFPhoto', DEBUG, 'ImageMagick found', 'The ImageMagick \
convert tool was found at %s in your search path.' % path)
                return True

    LOG('CMFPhoto', PROBLEM, 'ImageMagick not found', 'The ImageMagick \
        convert tool wasn\'t found in your search path: %s' % envPath)
    return False


isPilAvailable     = findPIL()
isConvertAvailable = findConvert()


if isPilAvailable:
    LOG('CMFPhoto', DEBUG, 'is using PIL to resize photos.')
elif not isPilAvailable and isConvertAvailable:
    LOG('CMFPhoto', DEBUG, 'is using the ImageMagick \
convert tool to resize photos.')
else:
    LOG('CMFPhoto', ERROR, 'No image converting tool was found', 
'CMFPhoto wasn\'t able to find PIL or ImageMagick! CMFPhoto \
needs one of these tools to resize photos!')

__all__ = ('isPilAvailable', 'isConvertAvailable')