from Products.Archetypes.public import *
from Products.Archetypes.Extensions.utils import installTypes, install_subskin
from Products.Archetypes import listTypes
from Products.CMFCore.utils import getToolByName, minimalpath, ContentInit
from Products.CMFCore.DirectoryView import addDirectoryViews, createDirectoryView
from Products.LinguaPlone.config import *
from StringIO import StringIO


def install(self):
    out = StringIO()

    if not hasattr(self, "_isPortalRoot"):
        print >> out, "Must be installed in a CMF Site (read Plone)"
        return
    
    print >> out, "Installing %s" % listTypes(PKG_NAME)
        
    qi = getToolByName(self, 'portal_quickinstaller', None)
    if qi is None:
        if required:
            raise RuntimeError, (
                'portal_quickinstaller tool could not be found, and is '
                'required to install LinguaPlone dependencies')
        else:
            return
    qi.installProduct('PloneLanguageTool',)
    print >> out, 'Checked for the existence of PloneLanguageTool.\n'

    installTypes(self, out, listTypes(PKG_NAME), PKG_NAME)

    install_subskin(self, out, GLOBALS)

    print >> out, 'Successfully installed types.'

    # add lanugage index and column to catalog
    catalogtool = getToolByName(self, 'portal_catalog')
    try: 
        catalogtool.addIndex('Language', 'FieldIndex')
        print >> out, 'Added Language to portal catalogs indexes.\n'
        catalogtool.reindexIndex('Language', None)
        print >> out, 'Reindexed Language index.\n'
    except: pass 
    try: 
	catalogtool.addColumn('Language')
        print >> out, 'Added Language to portal catalogs columns.\n'
    except: pass

    return out.getvalue()

