# -*- coding: utf-8 -*-
## LockWidget
## Copyright (C)2005 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""
LockWidget
"""
__docformat__ = 'restructuredtext'


# Zope imports
from AccessControl import ClassSecurityInfo

# CMF imports
from Products.CMFCore.utils import getToolByName

# Archetypes imports
from Products.Archetypes.Widget import BooleanWidget
from Products.Archetypes.Registry import registerWidget

class LockWidget(BooleanWidget):
    """Visibility depends on Lock support
    """
    _properties = BooleanWidget._properties.copy()

    security = ClassSecurityInfo()

    security.declarePublic('isVisible')
    def isVisible(self, instance, mode='view'):
        """ The widget is hidden if lock is not activated or if mode is 'edit'
        """
        portal_properties = getToolByName(instance, "portal_properties")
        props = portal_properties.ploneexfile_properties
        state = BooleanWidget.isVisible(self, instance, mode)
        if not props.use_lock or mode == 'edit':
            state = 'hidden'

        return state

__all__ = ('LockWidget',)

registerWidget(LockWidget,
               title='Lock',
               description='Renders a lock',
               used_for=('Products.Archetypes.Field.BooleanField',)
               )
