# -*- coding: utf-8 -*-
##
## Copyright (C)2005 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

"""PloneExFile tests

$Id: PloneExFileTestCase.py,v 1.9 2006/03/08 21:25:38 encolpe Exp $
"""
__docformat__ = 'restructuredtext'



__author__ = ''

# Python imports
import time

# Zope imports
from Testing import ZopeTestCase
from AccessControl.SecurityManagement import newSecurityManager
from AccessControl.SecurityManagement import noSecurityManager
from Acquisition import aq_base
from OFS.Image import File

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName

# Plone imports
from Products.CMFPlone.tests import PloneTestCase

# Products imports
from Products.PloneExFile.Extensions.Install import install as installPloneExFile
from Products.PloneExFile.Permissions import EditExFile, LockExFile

portal_name = PloneTestCase.portal_name
portal_owner = PloneTestCase.portal_owner
portal_member = 'portal_member'
portal_member2 = 'portal_member2'
portal_member3 = 'portal_member3'

class PloneExFileTestCase(PloneTestCase.PloneTestCase):
    """ PloneExFile test case based on a plone site"""

    def afterSetUp(self):
        # Tools shortcuts
        self.cat_tool = getToolByName(self.portal, 'portal_catalog')
        self.type_tool = getToolByName(self.portal, 'portal_types')
        self.wf_tool = getToolByName(self.portal, 'portal_workflow')
        props = getToolByName(self.portal, 'portal_properties')
        self.exfile_tool = props.ploneexfile_properties
        self.mb_tool = getToolByName(self.portal, 'portal_membership')
        self.member_folder = self.mb_tool.getHomeFolder(portal_member)

        wf = getattr(self.wf_tool, 'plone_workflow')
        #raise repr(wf.meta_type)
        wf.addManagedPermission(EditExFile)
        wf.states['pending'].setPermission(EditExFile, 0, ['Manager', 'Owner'])
        wf.states['private'].setPermission(EditExFile, 0, ['Manager', 'Owner'])
        wf.states['published'].setPermission(EditExFile, 0, ['Manager', 'Owner'])
        wf.states['visible'].setPermission(EditExFile, 0, ['Manager', 'Owner'])

        wf.addManagedPermission(LockExFile)
        wf.states['pending'].setPermission(LockExFile, 0, ['Manager'])
        wf.states['private'].setPermission(LockExFile, 0, ['Manager'])
        wf.states['published'].setPermission(LockExFile, 0, ['Manager'])
        wf.states['visible'].setPermission(LockExFile, 0, ['Manager'])
        self.wf_tool.updateRoleMappings()

    def createEmptyFile(self, container, content_id = 'file', **kwargs):
        # return empty file
        container.invokeFactory(type_name='PloneExFile', id=content_id, **kwargs)
        exfile = getattr(container, content_id)

        return exfile

    def createFullFile(self, container, content_id = 'file'):
        # create full file
        upload_file = self.createFileObject('test.doc', 'test.doc')
        return self.createEmptyFile(container, content_id, file=upload_file)


    def createFileObject(self, file_id, file_path):
        f = open(file_path)
        file_obj = File(file_id, file_id, f)
        setattr(file_obj, 'filename', file_id)
        f.close()

        return file_obj

    def beforeTearDown(self):
        # logout
        noSecurityManager()

    def loginAsPortalMember(self):
        '''Use if you need to manipulate an exfile as member.'''
        uf = self.portal.acl_users
        user = uf.getUserById(portal_member).__of__(uf)
        newSecurityManager(None, user)

    def loginAsPortalMember2(self):
        '''Use if you need to manipulate an exfile as member.'''
        uf = self.portal.acl_users
        user = uf.getUserById(portal_member2).__of__(uf)
        newSecurityManager(None, user)

    def loginAsPortalMember3(self):
        '''Use if you need to manipulate an exfile as member.'''
        uf = self.portal.acl_users
        user = uf.getUserById(portal_member3).__of__(uf)
        newSecurityManager(None, user)

    def loginAsPortalOwner(self):
        '''Use if you need to manipulate an exfile as member.'''
        uf = self.app.acl_users
        user = uf.getUserById(portal_owner).__of__(uf)
        newSecurityManager(None, user)

    def setMember2UnlockPermission(self, obj):
        """ Set unlock permission on an object for all members (basic test).
        """
        wf = getattr(self.wf_tool, 'plone_workflow')
        wf.states['pending'].setPermission(LockExFile, 0, ['Manager', 'Member', 'Owner'])
        wf.states['private'].setPermission(LockExFile, 0, ['Manager', 'Member', 'Owner'])
        wf.states['published'].setPermission(LockExFile, 0, ['Manager', 'Member', 'Owner'])
        wf.states['visible'].setPermission(LockExFile, 0, ['Manager', 'Member', 'Owner'])
        self.wf_tool.updateRoleMappings()

        self.portal.manage_permission(LockExFile, roles=('Member', 'Manager'), acquire=0)
        obj.manage_role('Member', obj.permissionsOfRole('Member') + [LockExFile])

def setupPloneExFile(app, quiet=0):
    get_transaction().begin()
    _start = time.time()
    portal = app.portal

    if not quiet: ZopeTestCase._print('Installing PloneExFile ... ')

    # login as manager
    user = app.acl_users.getUserById(portal_owner).__of__(app.acl_users)
    newSecurityManager(None, user)

    # install Attachmentfield
    portal_skins = getToolByName(portal, 'portal_skins')
    portal_qi = getToolByName(portal, 'portal_quickinstaller')
    if hasattr(portal_skins, 'attachmentfield'):
        ZopeTestCase._print('Attachment field already installed ... ')
    else:
        portal_qi.installProduct('AttachmentField')

    # add PloneExFile
    props = getToolByName(portal, 'portal_properties')
    if hasattr(props, 'ploneexfile_properties'):
        ZopeTestCase._print('PloneExFile already installed ... ')
    else:
        portal_qi.installProduct('PloneExFile')

    # Create 2 portal members
    portal.portal_registration.addMember(portal_member, 'azerty', ['Member'])
    portal.portal_registration.addMember(portal_member2, 'azerty', ['Member'])
    portal.portal_registration.addMember(portal_member3, 'azerty', ['Member', 'Owner'])

    CMFCorePermissions.setDefaultRoles(LockExFile, ['Manager', 'Owner'])
    CMFCorePermissions.setDefaultRoles(EditExFile, ['Manager', 'Owner'])

    # Log out
    noSecurityManager()
    get_transaction().commit()
    if not quiet: ZopeTestCase._print('done (%.3fs)\n' % (time.time()-_start,))

app = ZopeTestCase.app()
setupPloneExFile(app)
ZopeTestCase.close(app)
