import OFS.PropertySheets
from ComputedAttribute import ComputedAttribute
from Globals import default__class_init__, Dictionary
from ZClasses.Property import klass_sequence, ClassCaretaker, ZCommonSheet

class VirtualSheets(OFS.PropertySheets.PropertySheets):

    """Ensure that virtual propertysheets are included in sheets"""

    def __propsets__(self):
        propsets = self._get_defaults()+self.aq_inner.aq_parent._v_currentSheets
        r=[]
        for id in klass_sequence(self.__class__,'__propset_attrs__').keys():
            r.append(getattr(self,id))
        return propsets+tuple(r)

    def get(self,name,default=None):
        for propset in self._get_defaults():
            if propset.id==name or propset.xml_namespace()==name:
                return propset.__of__(self)

        client = self.aq_inner.aq_parent
        s = client._delegateToSheetProviders(name,name,'_PropertySheetFor')

        if s is not None: return s.__of__(self)
        return default


    def __bobo_traverse__(self, REQUEST, name=None):
        for propset in self._get_defaults():
            if propset.id==name:
                return propset.__of__(self)

        client = self.aq_inner.aq_parent
        s = client._delegateToSheetProviders(name,'','_PropertySheetFor')
        
        if s is not None: return s.__of__(self)
        return getattr(self, name)



    def manage_addPropertySheet(self, id, ns):
        """ """
        if self.aq_inner.aq_parent._addPropertySheet(id,ns):
            return 'OK'

    def manage_delPropertySheet(self, name='', xmlns=''):
        """ """
        self.aq_inner.aq_parent._delPropertySheet(name,xmlns)
        return 'OK'

    __ac_permissions__ = (
        ("Manage properties",
            ('manage_addPropertySheet','manage_delPropertySheet')
        ),
    )

    _implements_the_notional_subclassable_propertysheet_class_interface=1

    def propertyLabel(self,id):
        return id   # Hack to make sheets UI work
        
default__class_init__(VirtualSheets)



















# ZClass propertysheet helpers

class DefaultCaretaker(ClassCaretaker):
    # Map attributes to 'class_default_for_' variables
    
    def __getattr__(self,name):
        return ClassCaretaker.__getattr__(self,'class_default_for_'+name)

    def __setattr__(self,name,value):
        ClassCaretaker.__setattr__(self,'class_default_for_'+name,value)

    def __delattr__(self,name):
        ClassCaretaker.__delattr__(self,'class_default_for_'+name)


class DataSkinSheet(ZCommonSheet):
    """Property sheet that creates class defaults for properties"""

    meta_type="DataSkin Attribute Property Sheet"

    def v_self(self):
        klass=self.aq_inner.aq_parent.aq_parent.aq_parent._zclass_
        return DefaultCaretaker(klass)


















def SheetAttribute(name='',xmlns=''):
	def getsheet(self,name=name,xmlns=xmlns):
		return self.PropertySheet(name=name,xmlns=xmlns)
	return ComputedAttribute(getsheet)

