######################################################################
# constants and built-in defaults for ZWiki

DEFAULT_PAGE_TYPE = 'structuredtext'
DISABLE_JAVASCRIPT = 1
LARGE_FILE_SIZE = 1024*1024
PERMPREFIX = '' # 'ZWiki:'

# built-in DTML defaults - to override these, define any of the
# following as DTML methods (python scripts, properties ?):
#
# standard_wiki_header
# standard_wiki_footer
# standard_wiki_page
# editform
# backlinks
# titleprefix

import DocumentTemplate
from DocumentTemplate import HTMLFile
#from Globals import HTMLFile

# ? the ramifications of when and where this dtml gets executed are
# not yet clear ...
# would like to move these to separate files.. how do I define
# these in such a way that "<dtml-var id>" will work at runtime ?

#default_wiki_page = DocumentTemplate.HTMLFile('dtml/default_wiki_page', globals())

default_wiki_page = DocumentTemplate.HTML(source_string=\
'''Describe <dtml-var page> here
''')

# also would prefer not to inline the header in editform & backlinks

#default_wiki_header = HTMLFile('dtml/default_wiki_header', globals())
#default_wiki_footer = HTMLFile('dtml/default_wiki_footer', globals())
#default_editform =    HTMLFile('dtml/default_editform', globals())
#default_backlinks =   HTMLFile('dtml/default_backlinks', globals())

default_wiki_header = DocumentTemplate.HTML(source_string=\
'''<HTML>
<HEAD>
<TITLE><dtml-var titleprefix missing><dtml-var id></TITLE>
</HEAD>
<BODY BGCOLOR="#FFFFFF">
<table width="100%" border="0" cellspacing="0" cellpadding="3"  bgcolor="eeeeff">
<tr>
<td valign="bottom">
<h1>
<a href="&dtml-wiki_url;/"><img src="/misc_/ZWiki/ZWikiPage_icon.gif" height=32 width=32 border=0 valign="bottom" alt="to FrontPage"></a>
<a href="&dtml-page_url;/backlinks"><dtml-var id></a>
</h1>
</td>
<td valign="top" align="right"  bgcolor="eeeeff">&nbsp;
</td>
</tr>
</table>
<p>
<!-- end of default_wiki_header -->

''')

default_wiki_footer = DocumentTemplate.HTML(source_string=\
'''
<!-- start of default_wiki_footer -->
<p>
<table width="100%" border="0" cellspacing="0" cellpadding="3" bgcolor="eeeeff">
<tr>
<td valign="middle" align="left">
<small><em>
Last edited <dtml-var bobobase_modification_time>
</em></small>
</td>
<td valign="middle" align="right">
<a href="&dtml-wiki_url;/<dtml-var id url_quote>/editform">Edit this page</a>
</td>
</tr></table>
</BODY>
</HTML>
''')

default_editform = DocumentTemplate.HTML(source_string=\
'''<HTML>
<HEAD>
<TITLE><dtml-var titleprefix missing><dtml-var id></TITLE>
</HEAD>
<BODY BGCOLOR="#FFFFFF">
<table width="100%" border="0" cellspacing="0" cellpadding="3"  bgcolor="eeeeff">
<tr>
<td valign="bottom">
<h1>
<a href="&dtml-wiki_url;/"><img src="/misc_/ZWiki/ZWikiPage_icon.gif" height=32 width=32 border=0 valign="bottom" alt="to FrontPage"></a>
<a href="&dtml-page_url;/backlinks"><dtml-var id></a>
</h1>
</td>
<td valign="top" align="right"  bgcolor="eeeeff">&nbsp;
</td>
</tr>
</table>
<p>
<!-- end of default_wiki_header -->

<FORM METHOD="POST" ACTION="&dtml-wiki_url;/<dtml-var oldid url_quote>/edit" ENCTYPE="multipart/form-data">
<input name=timeStamp type=hidden value="&dtml-editTimestamp;">
<input name=page type=hidden value="&dtml-id;">

<div align="center">
<TEXTAREA WRAP="virtual" NAME="text" ROWS=<dtml-var zwiki_height missing=25> COLS=<dtml-var zwiki_width missing=80>>
<dtml-var text html_quote></TEXTAREA>
</div>
<br>
<table width="100%" border="0" cellspacing="0" cellpadding="3" bgcolor="eeeeff">
<tr>
<td valign="middle" align="left">
See 
<a href="&dtml-wiki_url;/HowDoIEdit">HowDoIEdit</a> or
<a href="&dtml-wiki_url;/TextFormattingRules">TextFormattingRules</a>
for more help
</td>
<td valign="middle" align="right">
<INPUT TYPE="submit" NAME="<dtml-var action>" VALUE=" <dtml-var action> <dtml-var id> ">
<dtml-comment>give some indication of permissions</dtml-comment>
<dtml-if "(action == 'Create' and not AUTHENTICATED_USER.has_permission('Add ZWiki Pages',aq_parent)) or
          (action == 'Change' and not AUTHENTICATED_USER.has_permission('Change ZWiki Pages',this()))">
<br><em>(login required)</em>
</dtml-if>
</td>
</tr>
</table>
<br>
</FORM>
</body>
</html>
''')

default_backlinks = DocumentTemplate.HTML(source_string=\
'''<HTML>
<HEAD>
<TITLE><dtml-var titleprefix missing><dtml-var id></TITLE>
</HEAD>
<BODY BGCOLOR="#FFFFFF">
<table width="100%" border="0" cellspacing="0" cellpadding="3"  bgcolor="eeeeff">
<tr>
<td valign="bottom">
<h1>
<a href="&dtml-wiki_url;/"><img src="/misc_/ZWiki/ZWikiPage_icon.gif" height=32 width=32 border=0 valign="bottom" alt="to FrontPage"></a>
<a href="&dtml-page_url;/backlinks"><dtml-var id></a>
</h1>
</td>
<td valign="top" align="right"  bgcolor="eeeeff">&nbsp;
</td>
</tr>
</table>
<p>
<!-- end of default_wiki_header -->

<dtml-let thispage=id>
The following pages link to <a href="&dtml-page_url;"><dtml-var id></a>:
<p>
<dtml-in "aq_parent.objectValues(spec='ZWiki Page')" sort=id>
<dtml-unless "_.string.find(_.getitem('sequence-item').raw,thispage) == -1">
<a href="&dtml-wiki_url;/<dtml-var "_.getitem('id')()" url_quote>"><dtml-var "_.getitem('id')()"></a><br>
</dtml-unless>
</dtml-in>
</dtml-let>
</body>
</html>
''')

default_subscribeform = DocumentTemplate.HTML(source_string=\
'''<HTML>
<HEAD>
<TITLE><dtml-var titleprefix missing><dtml-var id></TITLE>
</HEAD>
<BODY BGCOLOR="#FFFFFF">
<table width="100%" border="0" cellspacing="0" cellpadding="3"  bgcolor="eeeeff">
<tr>
<td valign="bottom">
<h1>
<a href="&dtml-wiki_url;/"><img src="/misc_/ZWiki/ZWikiPage_icon.gif" height=32 width=32 border=0 valign="bottom" alt="to FrontPage"></a>
Mail subscription
</h1>
</td>
<td valign="top" align="right"  bgcolor="eeeeff">&nbsp;
</td>
</tr>
</table>
<p>
<!-- end of header -->

<!-- remember email address like on UserOptions -->
<dtml-if emailchanged>
<dtml-call "RESPONSE.setCookie('email',REQUEST.email,path='/',expires=(ZopeTime() + 365).rfc822())">
</dtml-if>

<FORM METHOD="POST" ACTION="&dtml-page_url;/subscribeform" ENCTYPE="multipart/form-data">
Subscribers receive a copy of all edits via email.
You may subscribe either to this individual page, or to the wiki as a whole.

<br><br>

<dtml-if email>
Your email address:
<dtml-else>
To subscribe or unsubscribe, please first enter your email address:
</dtml-if>
<br>
<input name="email" type="text" value="<dtml-var email missing>">
<input name="emailchanged" type="hidden" value="1">
<INPUT TYPE="submit" NAME="../subscribeform:method" VALUE=" Change ">
<br><br>

<table width="100%" cellpadding="0" cellspacing="0" border="0">
<tr valign="top">
<td valign="top">

<dtml-if email>
You are currently
<b><dtml-unless "isSubscriber(email)">
not
</dtml-unless>
subscribed</b><br>
to <dtml-var id>.
</dtml-if>
<dtml-if email>
<br>
<dtml-if "isSubscriber(email)">
<INPUT TYPE="submit" NAME="../unsubscribe:method" VALUE=" Unsubscribe from &dtml-id; " style="font-weight:bold">
<dtml-else>
<INPUT TYPE="submit" NAME="../subscribe:method" VALUE=" Subscribe to &dtml-id; " style="font-weight:bold">
</dtml-if>
<br>
</dtml-if>

<br>
<dtml-let n="subscriberCount()">
There <dtml-if "n==1">is<dtml-else>are</dtml-if> &dtml-n; 
subscriber<dtml-unless "n==1">s</dtml-unless> to this page
<dtml-if n>:<br>
<dtml-in "_.string.split(subscriberList(),' ')">
<dtml-var sequence-item><br>
</dtml-in>
</dtml-if>
</dtml-let>
<br><br>

</td>
<td valign="top">

<dtml-if email>
You are currently
<b><dtml-unless "isWikiSubscriber(email)">
not
</dtml-unless>
subscribed</b><br>
to the whole wiki.
</dtml-if>
<dtml-if email>
<br>
<dtml-if "isWikiSubscriber(email)">
<INPUT TYPE="submit" NAME="../wikiUnsubscribe:method" VALUE=" Unsubscribe from the whole wiki " style="font-weight:bold">
<dtml-else>
<INPUT TYPE="submit" NAME="../wikiSubscribe:method" VALUE=" Subscribe to the whole wiki " style="font-weight:bold">
</dtml-if>
<br>
</dtml-if>

<br>
<dtml-let n="wikiSubscriberCount()">
There <dtml-if "n==1">is<dtml-else>are</dtml-if> &dtml-n; 
subscriber<dtml-unless "n==1">s</dtml-unless> to the whole wiki
<dtml-if n>:<br>
<dtml-in "_.string.split(wikiSubscriberList(),' ')">
<dtml-var sequence-item><br>
</dtml-in>
</dtml-if>
</dtml-let>
<br><br>

</td>
</tr>
</table>

<INPUT TYPE="submit" NAME="..:method" VALUE=" Go back to &dtml-id; ">


</FORM>
</body>
</html>
''')

