/****************************************************************************
**
** Copyright (C) 2003-2006 Tilo Riemer <riemer@crossvc.com>,
**                         Frank Hemer <frank@hemer.org>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#include "config.h"

#include "globals.h"
#include "FileListViewItem.h"

FileListViewItem::FileListViewItem(QListView *parent,int t1,int t2,int t3,int t4,int t5,int t6,int t7,int t8)
: QListViewItem( parent), m_pDateTime(NULL), m_pModifiedDateTime(NULL), m_isDir(FALSE)
{
   m_type[0] = t1;
   m_type[1] = t2;
   m_type[2] = t3;
   m_type[3] = t4;
   m_type[4] = t5;
   m_type[5] = t6;
   m_type[6] = t7;
   m_type[7] = t8;
}

FileListViewItem::FileListViewItem(QListView *parent,bool isDir/*=FALSE*/,int t1,int t2,int t3,int t4,int t5,int t6,int t7,int t8)
: QListViewItem( parent), m_pDateTime(NULL), m_pModifiedDateTime(NULL), m_isDir(isDir)
{
   m_type[0] = t1;
   m_type[1] = t2;
   m_type[2] = t3;
   m_type[3] = t4;
   m_type[4] = t5;
   m_type[5] = t6;
   m_type[6] = t7;
   m_type[7] = t8;
}

FileListViewItem::FileListViewItem (QListView * parent, QString label1, int t1,
                                    QString label2, int t2, QString label3, int t3,
                                    QString label4, int t4, QString label5, int t5,
                                    QString label6, int t6, QString label7, int t7,
                                    QString label8, int t8)
: QListViewItem( parent, label1, label2, label3, label4, label5, label6, label7, label8),
  m_pDateTime(NULL), m_pModifiedDateTime(NULL), m_isDir(FALSE)
{
   m_type[0] = t1;
   m_type[1] = t2;
   m_type[2] = t3;
   m_type[3] = t4;
   m_type[4] = t5;
   m_type[5] = t6;
   m_type[6] = t7;
   m_type[7] = t8;
}    

FileListViewItem::~FileListViewItem() {
   if (m_pDateTime) delete m_pDateTime;
   if (m_pModifiedDateTime) delete m_pModifiedDateTime;
}

FileListViewItem * FileListViewItem::nextSibling() const {
   return static_cast<FileListViewItem*>(QListViewItem::nextSibling());
}

void FileListViewItem::setDate(int col, const QDateTime * dateTime, const QString txt /* = ""*/) {
   if (m_pDateTime) *m_pDateTime = *dateTime;
   else m_pDateTime = new QDateTime(*dateTime);
   m_type[col] = Date;
   setText(col,txt);
}

void FileListViewItem::setModifiedDate(int col, const QDateTime * dateTime, const QString txt /* = ""*/) {
   if (m_pModifiedDateTime) *m_pModifiedDateTime = *dateTime;
   else m_pModifiedDateTime = new QDateTime(*dateTime);
   m_type[col] = ModDate;
   setText(col,txt);
}

int FileListViewItem::compare ( QListViewItem * i, int col, bool ascending) const {
   
   FileListViewItem * item = static_cast<FileListViewItem *>(i);
   switch (m_type[col]) {
      case None: {
         return 0;
      }
      case Text: {
         return QString::localeAwareCompare(text(col),item->text(col));
      }
      case TextNoCase: {
         return QString::localeAwareCompare(text(col).upper(),item->text(col).upper());
      }
      case Num: {
         return QString::localeAwareCompare(text(col),item->text(col));
      }
      case Rev: {
         int c1 = text(col).contains('.');
         int c2 = item->text(col).contains('.');
         if (c1 == 0 || c2 == 0) {
            return QString::localeAwareCompare(text(col).upper(),item->text(col).upper());
         } else if (c1 != c2) {
            return (c1-c2);
         } else {
            int i = 0;
            QString s1 = text(col).section('.',i,i);
            QString s2 = item->text(col).section('.',i,i);
            do {
               if (s1 != s2) {
                  return (s1.toInt()-s2.toInt());
               }
               ++i;
               s1 = text(col).section('.',i,i);
               s2 = item->text(col).section('.',i,i);
            } while (i < c1);
            return (s1.toInt()-s2.toInt());
         }
      }
      case Date: {
         if (m_pDateTime && item->m_pDateTime) {
            return dateCompare(m_pDateTime,item->m_pDateTime);
         } else {
            qDebug("FileListViewItem: no 'Date' to compare");
            return 0;
         }
      }
      case ModDate: {
         if (m_pModifiedDateTime && item->m_pModifiedDateTime) {
            return dateCompare(m_pModifiedDateTime,item->m_pModifiedDateTime);
         } else {
            qDebug("FileListViewItem: no 'ModDate' to compare");
            return 0;
         }
      }
      default: {
         qDebug("FileListViewItem: no values set");
         return QListViewItem::compare(i,col,ascending);
      }
   }
}

int FileListViewItem::dateCompare(QDateTime * dt1, QDateTime * dt2) const {
   if ((*dt1)<(*dt2)) return -1;
   else if ((*dt1)>(*dt2)) return 1;
   else return 0;
}

