static char qalter_rcsid[]="qalter.c,v 1.2 1994/11/28 16:55:27 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qalter.c,v
 * Revision 1.2  1994/11/28  16:55:27  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  02:59:18  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qalter_popup;
static Widget           widget_qalterrc;
static Widget           widget_qalterlabel;
static Widget           widget_qalterframe;
static Widget           widget_qaltermenu;
static Widget           widget_qaltermain;
static Widget           widget_qalterexec;
static Widget           widget_qalterclear;
static Widget           widget_qalterclose;
static Widget           widget_qalterseparator;
static Widget           widget_qalteropt;

struct optionstruct qaltermenu[]={
  0,"Date/Time         ","-a",   INPUTTYPE,NULL,NULL,
  0,"Account List   ","-A",   MENUTYPE,NULL,NULL,
  0,"Cell           ","-cell",   MENUTYPE,NULL,NULL,
  0,"Clean             ","-clean",   FLAGTYPE,"False",NULL,
  0,"CWD               ","-cwd",   FLAGTYPE,"False",NULL,
  0,"Directive Prefix  ","-C",   FLAGTYPE,"False",NULL,
  0,"Std. Error Path   ","-e",   INPUTTYPE,NULL,NULL,
  0,"User  Hold        ","-h",  FLAGTYPE,"False",NULL,
  0,"Hard              ","-hard", FLAGTYPE,"False",NULL,
  0,"Help              ","-help", FLAGTYPE,"False",NULL,
  0,"Join-Paths        ","-j",  FLAGTYPE,"False",NULL,
  0,"Job ID            ","-hold_jid",  INPUTTYPE,NULL,NULL,
  0,"Resource List     ","-l",  INPUTTYPE,NULL,NULL,
  0,"Mail at Abort     ","-m a", FLAGTYPE,"False",NULL,
  0,"Mail at Beginning ","-m b", FLAGTYPE,"False",NULL,
  0,"Mail at Exit      ","-m e", FLAGTYPE,"False",NULL,
  0,"No Mail           ","-m n", FLAGTYPE,"False",NULL,
  0,"Mail at Suspension","-m s", FLAGTYPE,"False",NULL,
  0,"Master Queue   ","-master",  MENUTYPE,NULL,NULL,
  0,"Mailing List      ","-M",  INPUTTYPE,NULL,NULL,
  0,"Notify            ","-notify", FLAGTYPE,"False",NULL,
  0,"Job Name          ","-N",  INPUTTYPE,NULL,NULL,
  0,"Std. Output Path  ","-o",   INPUTTYPE,NULL,NULL,
  0,"Priority          ","-p",   INPUTTYPE,NULL,NULL,
  0,"Password          ","-passwd", FLAGTYPE,"False",NULL,
  0,"Password File     ","-passwd_file",   INPUTTYPE,NULL,NULL,
  0,"Destination    ","-q",   MENUTYPE,NULL,NULL,
  0,"Rerunable         ","-r", FLAGTYPE,"False",NULL,
  0,"Soft              ","-soft", FLAGTYPE,"False",NULL,
  0,"Reauthenticate    ","-reauth", INPUTTYPE,NULL,NULL,
  0,"Shell Path List   ","-S",   INPUTTYPE,NULL,NULL,
  0,"Variable List     ","-v",   INPUTTYPE,NULL,NULL,
  0,"Verify            ","-verify",   FLAGTYPE,"FALSE",NULL,
  0,"Export Variables  ","-V",   FLAGTYPE,"FALSE",NULL,
  0,"O/P job id ?      ","-z",   FLAGTYPE,"FALSE",NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};

/*
  0,"User List         ","-u",   INPUTTYPE,NULL,NULL,
  0,"Interval          ","-c",   INPUTTYPE,NULL,NULL,
  0,"Hold System       ","-h s",  FLAGTYPE,"False",NULL,
  0,"Hold Other        ","-h o",  FLAGTYPE,"False",NULL,
  0,"No Hold           ","-h n",  FLAGTYPE,"False",NULL,
  0,"Parallel          ","-par",   INPUTTYPE,NULL,NULL,
  0,"Keep (e/n/o)      ","-k",   INPUTTYPE,NULL,NULL,
*/

/***********************************************************
 * pb_qalterexec - Activate callback for exec
 */
XtCallbackProc pb_qalterexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QALTER_BINARY,qaltermenu,0);
  sleep(2);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qalterclear - Activate callback for clear
 */
XtCallbackProc pb_qalterclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  int n=0;
  clearsubmenu(qaltermenu); 
  QmonTextSetString(qaltermenu[n].widgetid ,current_date ); n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_account ); n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_cell ); n++;
  n++;
  n++;
  n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_errpath ); n++;
  QmonToggleSetState(qaltermenu[n].widgetid ,current_holduser ); n++;
  QmonToggleSetState(qaltermenu[n].widgetid ,current_hard ); n++;
  n++;
  n++;
  n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_resource ); n++;
  n++;
  n++;
  n++;
  n++;
  n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_mqueue ); n++;
  n++;
  n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_jobname ); n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_outpath ); n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_priority ); n++;
  n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_passwdfile ); n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_destination ); n++;
  QmonToggleSetState(qaltermenu[n].widgetid ,current_rerun ); n++;
  QmonToggleSetState(qaltermenu[n].widgetid ,current_soft ); n++;
  n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_shellpath ); n++;
  QmonTextSetString(qaltermenu[n].widgetid ,current_exportvars ); n++;
  n++;   
}


/***********************************************************
 * pb_qalterclose - Activate callback for close
 */

XtCallbackProc pb_qalterclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qalter_dialog - Create widgets used for the qalter menu
 */
int create_qalter_dialog(Widget w, XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qalter_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  qaltermenu[1].list = account_list;
  qaltermenu[2].list = cell_list;
  qaltermenu[18].list = queue_list;
  qaltermenu[26].list = queue_list;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qalter_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qalter_form = XtCreateManagedWidget("form", formWidgetClass, qalter_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qalterlabel=
        XtCreateManagedWidget("Qalter",labelWidgetClass,qalter_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qalterlabel); ii++;
  widget_qaltermain=XtCreateManagedWidget("box",formWidgetClass,qalter_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_qaltermain,NULL,"Exec",(XtCallbackProc)pb_qalterexec,NULL);
 clear=QmonAddButtonN(widget_qaltermain,exec,"Clear",(XtCallbackProc)pb_qalterclear,NULL);
 close=QmonAddButtonN(widget_qaltermain,clear,"Close",(XtCallbackProc)pb_qalterclose,NULL);

  widget_qalteropt=createmenuoptions(qalter_form,widget_qaltermain,qaltermenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qalter - Open the qalter menu
 */
int openwidget_qalter()
{
  pb_qalterclear(NULL,NULL,NULL);
  XtPopup(qalter_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qalter - Close the qalter menu
 */
int closewidget_qalter()
{
   XtPopdown(qalter_popup);
}
