static char setup_rcsid[]="setup.c,v 1.2 1994/11/28 16:56:15 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  setup.c,v
 * Revision 1.2  1994/11/28  16:56:15  kerce
 * *** empty log message ***
 *
 * Revision 1.2  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:34  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           setup_popup=NULL;
static Widget           widget_setupmain;
static Widget           widget_setuplabel;
static Widget           widget_rcsetupv;
static Widget           widget_rcsetup;
static Widget           widget_showgroups;
static Widget           widget_showgroupsframe;
static Widget           widget_showsetups;
static Widget           widget_showsetupsframe;
static Widget           widget_label;
static Widget           widget_separator;
static Widget           widget_running;
static Widget           widget_idle;
static Widget           widget_suspended;
static Widget           widget_sus_on_comp;
static Widget           widget_alarm;
static Widget           widget_phtframe;
static Widget           widget_phtsetup;
static Widget           widget_phtclose;
static Widget           widget_phtcompact;
static int              showrunningflag=1;
static int              showidleflag=1;
static int              showsuspendedflag=1;
static int              showalarmflag=1;
static int              showsuscompflag=1;
static int              totalgroups=0;

struct icongroupstruct {
  char   *groupname;
  int    showit;
  Widget wid;
} icongroup[MAX_GROUPS];

extern Widget iconwin;
extern Widget viewicon;
extern char   *usergrparray[MAX_GROUPS];


/***********************************************************
 * toggle_setup - Toggle the flag for the state of a setup
 */
int toggle_setup(Widget w, int client_data, caddr_t call_data)
{
  int             tmp;

  if(w==widget_running)
    tmp=showrunningflag^=1;
  else if(w==widget_idle)
    tmp=showidleflag^=1;
  else if(w==widget_suspended)
    tmp=showsuspendedflag^=1;
  else if(w==widget_alarm)
    tmp=showalarmflag^=1;
  else if(w==widget_sus_on_comp)
    tmp=showsuscompflag^=1;
  UnMapIconWin ();
  refreshicons();
  if(tmp)
  pb_setupcompact(w,client_data,call_data);
  MapIconWin ();
}


/***********************************************************
 * pb_setupclose - Closes the setup window
 */
int pb_setupclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * pb_setupcompact - Reorders the displayed icons, removing
 *                 any blank spaces
 */
int pb_setupcompact(Widget w, int client_data, caddr_t call_data)
{
  busycursor ();
  if(client_data) 
	UnMapIconWin ();
  unmanageallicons();
  mapmanagedicons();
  defaultcursor ();
  if(client_data) 
	MapIconWin ();
}


/***********************************************************
 * toggle_group - Toggle the flag for the setup groups
 */
int toggle_group(Widget w, int client_data, caddr_t call_data)
{
  int             ii;
  
  for(ii=0;ii<totalgroups;ii++) {
    if(w==icongroup[ii].wid) {
      icongroup[ii].showit^=1;
      break;
    }
  }

  UnMapIconWin ();
  refreshicons();
  if(icongroup[ii].showit)
    pb_setupcompact(w,client_data,call_data);
  MapIconWin ();
/*
*/
}


/***********************************************************
 * showgroup - Return 1 if the group icon should be displayed
 */
int showgroup(char *group)
{
  unsigned ii;
  char       *ptr1=NULL;
  char       *ptr2=NULL;
  char       *tmp_grp=NULL;
  int        new=0;
  int        current=0, len ;

  ii = strlen(group);
  ptr1 =  malloc(ii+1);
  bzero(ptr1,ii+1);
  strncpy(ptr1,group,ii);
  while(ptr1) {
    ptr2 = strstr(ptr1,",");
    if(ptr2) {
        len = strlen(ptr1) - strlen(ptr2);
	tmp_grp =  malloc(len+1);
	bzero(tmp_grp,len+1);
	strncpy(tmp_grp,ptr1,len);
  	ptr1= strstr(ptr1,","); ptr1++; 
    }
    else {
        ii = strlen(ptr1);
	tmp_grp =  malloc(ii+1);
	bzero(tmp_grp,ii+1);	
	strncpy(tmp_grp,ptr1,ii);
  	ptr1= NULL;
    }
  for(ii=0;ii<totalgroups;ii++) {
    if(!strcmp(tmp_grp,icongroup[ii].groupname))
      new = icongroup[ii].showit;
  }
  if(new ) current++;
  ptr2 = NULL;

  }
  
  /*
   * If we cannot find it then just return 1
   */
  if(current) return 1;
  return 0;
}


/***********************************************************
 * showusergroup - Return 1 if the group icon should be displayed
 */
int showusergroup(char *group)
{
  int             ii;
  int j, n;
  Arg            args[32];
  char	*tmpptr=NULL;

  for(ii=0;ii<max_usergrps;ii++) {
    tmpptr=malloc(strlen(usergrparray[ii])+1);
    strcpy(tmpptr,usergrparray[ii]);
    j=strcmp(group,tmpptr);
    if(!j) 
      return 1 ;
  }
  
  /*
   * If we cannot find it then just return 0
   */
  return 0;
}

/***********************************************************
 * usergroup_setup () - find what the user wants to display
 *			in the icon window
 */
void usergroup_setup ()
{

  int ii,j,n;
  Arg             args[32];

  for(ii=0;ii<totalgroups;ii++) {
	j=showusergroup(icongroup[ii].groupname);
	if(!j) {
	icongroup[ii].showit=0;
  	n=0;
  	XtSetArg(args[n], XtNstate,True); n++;
  	XtSetValues(icongroup[ii].wid, args,n); 
	}
  }
}

/***********************************************************
 * showrunningsetups - Return showrunningflag
 */
int showrunningsetups()
{
  return showrunningflag;
}


/***********************************************************
 * showidlesetups - Return showidleflag
 */
int showidlesetups()
{
  return showidleflag;
}


/***********************************************************
 * showsuspendedsetups - Return showsuspendedflag
 */
int showsuspendedsetups()
{
  return showsuspendedflag;
}
/***********************************************************
 * showalarmqueues - Return showalarmflag
 */
int showalarmqueues()
{
  return showalarmflag;
}
/***********************************************************
 * showsuscompqueues - Return showsuscompflag
 */
int showsuscompqueues()
{
  return showsuscompflag;
}

/***********************************************************
 * showidlequeues - Return showidleflag
 */
int showidlequeues()
{
  return showidleflag;
}

/***********************************************************
 * showsuspendedqueues - Return showsuspendedflag
 */
int showsuspendedqueues()
{
  return showsuspendedflag;
}

/***********************************************************
 * showrunningqueues - Return showrunningflag
 */
int showrunningqueues()
{
  return showrunningflag;
}

/***********************************************************
 * showalarmsetups - Return showalarmflag
 */
int showalarmsetups()
{
  return showalarmflag;
}


/***********************************************************
 * showsuscompsetups - Return showsuscompflag
 */
int showsuscompsetups()
{
  return showsuscompflag;
}


/***********************************************************
 * create_setup_dialog - Create the widgets used for the
 *                       setup menu
 */
int create_setup_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  char            *ptr=NULL;
  int             ii;
  int             jj;
  int             n;
  Arg             args[32];
  Widget        setup_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec,clear,close;

  /*
   * Initialize icongroup structure
   */
  for(ii=0;ii<MAX_GROUPS;ii++)
    bzero(icongroup,sizeof(struct icongroupstruct));
  
  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);
    ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  setup_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  setup_form = XtCreateManagedWidget("form", formWidgetClass, setup_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_setuplabel=
        XtCreateManagedWidget("Setup",labelWidgetClass,setup_form,args
,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_setuplabel); ii++;
  widget_setupmain=XtCreateManagedWidget("box",formWidgetClass,setup_form,
                                        args,ii);

 exec=QmonAddButtonN(widget_setupmain,NULL,"Compact",(XtCallbackProc)pb_setupcompact,(XtPointer) 1);
 close=QmonAddButtonN(widget_setupmain,exec,"Close",(XtCallbackProc)pb_setupclose,NULL);


  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_setupmain); ii++;
  widget_rcsetup=XtCreateManagedWidget("box",formWidgetClass,setup_form,
                                        args,ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_label=
         XtCreateManagedWidget("Show Queues",
			labelWidgetClass,widget_rcsetup,args,ii);
  
  widget_running  =QmonAddToggleV(widget_rcsetup,widget_label,"Running ",(XtCallbackProc)toggle_setup,NULL); 
  widget_idle     =QmonAddToggleV(widget_rcsetup,widget_running,"Idle ",(XtCallbackProc)toggle_setup,NULL); 
  widget_suspended=QmonAddToggleV(widget_rcsetup,widget_idle,"Suspended ",(XtCallbackProc)toggle_setup,NULL); 
  widget_sus_on_comp  =QmonAddToggleV(widget_rcsetup,widget_suspended,"Suspend on Completion ",(XtCallbackProc)toggle_setup,NULL); 
  widget_alarm    =QmonAddToggleV(widget_rcsetup,widget_sus_on_comp,"Alarm ",(XtCallbackProc)toggle_setup,NULL); 
  
  /*
   * Create widget for showing groups
   */
  
  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_setupmain); ii++;
  XtSetArg(args[ii], XtNfromHoriz, widget_rcsetup); ii++;
  widget_showgroups=XtCreateManagedWidget("box",formWidgetClass,setup_form,
                                        args,ii);
  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_label=
         XtCreateManagedWidget("Show Complexes",
			labelWidgetClass,widget_showgroups,args,ii);
  
  /*
   * Keep getting groups until you reach a null
   */
  for(totalgroups=0;totalgroups<MAX_GROUPS;totalgroups++) {
    ptr = (char *)NULL;
    ptr=getgroup(totalgroups);
    if(!ptr)
      break;
    icongroup[totalgroups].groupname=ptr;
    icongroup[totalgroups].showit=1;
    icongroup[totalgroups].wid=NULL;
  }
  
    icongroup[0].wid =
	 QmonAddToggleV(widget_showgroups,widget_label,icongroup[0].groupname,(XtCallbackProc)toggle_group,NULL);
  for(jj=1;jj<totalgroups;jj++) {
    icongroup[jj].wid =
	 QmonAddToggleV(widget_showgroups,icongroup[jj-1].wid,icongroup[jj].groupname,(XtCallbackProc)toggle_group,NULL);
    }
}

/***********************************************************
 * add_to_setup  - add group button to setup panel   
 *
 */

void add_to_setup ()
{
    char *ptr;

    ptr = (char *)NULL;
    ptr=getgroup(totalgroups);
    if(!ptr) return;
    icongroup[totalgroups].groupname=ptr;
    icongroup[totalgroups].showit=1;
    icongroup[totalgroups].wid=NULL;
    icongroup[totalgroups].wid =
         QmonAddToggleV(widget_showgroups,icongroup[totalgroups-1].wid,icongroup[totalgroups].groupname,(XtCallbackProc)toggle_group,NULL);
    totalgroups++;

}
/***********************************************************
 * openwidget_setup - Open the main menu setup window
 */
int openwidget_setup()
{
  XtPopup(setup_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_setup - Close the main menu setup window
 */
int closewidget_setup()
{
  XtPopdown(setup_popup);
}
