//==============================================================================================
//  font3d.h                                                                       Font3D
//----------------------------------------------------------------------------------------------
//
//  Copyright (c) 1994-1996 by Todd A. Prater                                   Version 1.60
//  All rights reserved.
//
//----------------------------------------------------------------------------------------------
//
//  Permission to copy and distribute Font3D in its entirety, for noncommercial purposes,
//  is hereby granted without fee, provided that this license information and copyright 
//  notice appear in all copies. 
//
//  If you redistribute Font3D, the entire contents of this distribution must be distributed,
//  including the readme.txt, and register.txt files, and the complete set of documentation,
//  both ASCII text, and PostScript files. 
//
//  The software may be modified for your own purposes, but modified versions may not be
//  distributed without prior consent of the author.
//
//  This software is provided 'asis', without any express or implied warranty.  In no event
//  will the author be held liable for any damages arising from the use of this software.  
//
//  If you would like to do something with Font3D that this copyright prohibits (such as 
//  distributing it with a commercial product, using portions of the source in some other
//  program, distributing registered copies, etc.), please contact the author (preferably
//  via email).  Arrangements can probably be worked out.
//
//==============================================================================================

#ifndef __FONT3D_H__
#define __FONT3D_H__

#include <fstream.h>
#include <stddef.h>

#define RIGHT_HANDED          0
#define LEFT_HANDED           1

#define F3D_ERR_NoError           0
#define F3D_ERR_OutOfMemory       1
#define F3D_ERR_TableNotFound     2
#define F3D_ERR_UnknownCmapFormat 3
#define F3D_ERR_UnknownKernFormat 4
#define F3D_ERR_UnableToOpenFile  6
#define F3D_ERR_NoOptionsFound    8
#define F3D_ERR_InvalidOption     9
#define F3D_ERR_NoPolyFound      10
#define F3D_ERR_UnmatchedQuotes  11

#define RAW                   0
#define POV                   1
#define POV3                  2
#define RIB                   3
#define DXF                   4
#define DXF2                  5
#define VIVID                 6
#define ROUND                 7
#define FLAT                  8
#define SMOOTH                9
#define LEFT                 10
#define RIGHT                11
#define CENTER               12
#define BOTTOM               13
#define BASELINE             14
#define TOP                  15
#define BACK                 16
#define FRONT                17
#define RAD                  18

#define OFF                   0
#define ON                    1

#define MAC                   0
#define MS                    1

#define USENGLISH 0
#define UKENGLISH 1

#define DEGENERATE_THRESHOLD 1.0e-9

#define MAX_STRING_SIZE 1024
#define MAX_NUM_OPTIONS  200
#define MAX_LINE_LENGTH 2048
#define MAX_OPTIONS      200

#define MAX_FILENAME_SIZE 1024

#define SINGLE_QUOTE_CHAR '\''
#define DOUBLE_QUOTE_CHAR '"'
#define COMMENT_CHAR      '#'


   class Font3DOptions
   {
      public:
         char*   fontFileName;
         char*   fontPathName;
         char*   outputFileName;
         char*   outputPathName;
         char*   objectName;
         int     outputFormat;
         int     bevelType;
         int     triangleType;
         double  depth;
         int     xPosition;
         int     yPosition;
         int     zPosition;
         int     frontFaceVisible;
         int     backFaceVisible;
         int     frontBevelVisible;
         int     backBevelVisible;
         int     sideVisible;
         int     stringLength;
         int*    string;
         double  frontFaceCut;
         double  backFaceCut;
         double  frontSideCut;
         double  backSideCut;
         char*   frontFaceTextureName;
         char*   backFaceTextureName;
         char*   frontBevelTextureName;
         char*   backBevelTextureName;
         char*   sideTextureName;
         double  spacing;
         double  spaceto;
         double  threshold;
         int     resolution;
         int     mapType;
         int     language;
         int     outputPrecision;
         int     verbose;
         int     constants;
         int     csystem;
         int     reverse;
         double  reverseBorderVertical;
         double  reverseBorderHorizontal;

         Font3DOptions()
         {
            fontFileName          = NULL;
            fontPathName          = NULL;

            outputFileName        = new char[12];
            strcpy (outputFileName,"font3d.inc");

            outputPathName        = NULL;

            objectName            = new char[14];
            strcpy (objectName,"FONT3D_OBJECT");

            outputFormat          = POV;
            bevelType             = FLAT;
            triangleType          = SMOOTH;
            depth                 = 0.2;
            xPosition             = CENTER;
            yPosition             = CENTER;
            zPosition             = CENTER;
            frontFaceVisible      = TRUE;
            backFaceVisible       = TRUE;
            frontBevelVisible     = TRUE;
            backBevelVisible      = TRUE;
            sideVisible           = TRUE;

            string                = new int[strlen("Font3D")];
            stringLength          = strlen("Font3D");
            for (unsigned int i=0;i<strlen("Font3D");i++)
               string[i]=("Font3D")[i];

            frontFaceCut          = 0.0;
            backFaceCut           = 0.0;
            frontSideCut          = 0.0;
            backSideCut           = 0.0;
            frontFaceTextureName  = NULL;
            backFaceTextureName   = NULL;
            frontBevelTextureName = NULL;
            backBevelTextureName  = NULL;
            sideTextureName       = NULL;
            spacing               = 0.0;
            spaceto               = 0.0;
            threshold             = 0.4;  /* ? */
            resolution            = 5;
            mapType               = MICROSOFT;
            language              = LID_MS_USEnglish;
            outputPrecision       = 6;
            verbose               = TRUE;
            constants             = TRUE;
            csystem               = RIGHT_HANDED;
            reverse               = FALSE;
            reverseBorderVertical = 0.01;
            reverseBorderHorizontal = 0.01;
         }

   };

   int ReadOptions(char* fileName, int& numArgs, char ** & args);

   int ParseOptions(int numArgs, char* argument[], Font3DOptions& defaultOptions,
                    int& errorCode, int& errorPos);

#endif




