// ps.h for HDL_ANT.CPP
//
// started from
//point.h
// from Gorlen, K.E., Orlow, S.M., and Plexico, P.S., 
// Data Abstraction and Object-Oriented Programming in C++,
// -------------------------------------------------------
// Wiley, 1990, p. 105

#include <iostream.h>

class Point
{
    double xc,yc;          // x-y coordinates

friend ostream& operator<<(ostream&, const Point& );
    
public:
    Point()                             { xc = yc = 0; }
    Point(double newx, double newy)     { xc = newx; yc = newy; }
    double x() const                    { return xc; }
    double x(double newx)               { return xc = newx; }
    double y() const                    { return yc; }
    double y(double newy)               { return yc = newy; }

    Point operator+(const Point& p)  { return Point(xc + p.xc, yc + p.yc); } 

    void operator+=(const Point& p) 
    {   
        xc += p.x();
        yc += p.y();
    }

    void printOn(ostream& strm = cout) const;

};

void Point::printOn(ostream& strm) const
{
    strm << '(' << xc << ',' << yc << ')';
}    
 
ostream& operator<<(ostream& strm, const Point& p)
{
    p.printOn(strm);
    return strm;
}



class PS_point: public Point
{
    double xl,yl;          // x-y coordinates

friend ostream& operator<<(ostream&, const PS_point& );

public:
    PS_point()                     { xl = yl = 0; }
    PS_point(double newx, double newy)   { xl = newx; yl = newy; }
    PS_point(const Point& p)	    { xl = p.x(); yl = p.y(); }

    void operator=(const Point& p)    { xl = p.x(); yl = p.y(); }
  //				{ return PS_point(p.x(),p.y());}

    PS_point operator+(const PS_point& p)
				     { return PS_point(xl + p.xl, yl + p.yl);}

    void operator+=(const Point& p)
    {
	xl += p.x();
	yl += p.y();
    }

    void printOn(ostream& strm = cout) const;

};

void PS_point::printOn(ostream& strm) const
{
    strm << xl << " mm "  << yl << " mm ";
}

ostream& operator<<(ostream& strm, const PS_point& p)
{
    p.printOn(strm);
    return strm;
}



class PS_lineto: public Point
{
    double xl,yl;          // x-y coordinates

friend ostream& operator<<(ostream&, const PS_lineto& );

public:
    PS_lineto()                             { xl = yl = 0; }
    PS_lineto(double newx, double newy)     { xl = newx; yl = newy; }
    PS_lineto(const Point& p)	            { xl = p.x(); yl = p.y(); }

    void operator=(const Point& p)          { xl = p.x(); yl = p.y(); }
  //				{ return PS_lineto(p.x(),p.y());}

    PS_lineto operator+(const PS_lineto& p)
				     { return PS_lineto(xl + p.xl, yl + p.yl);}

    void operator+=(const Point& p)
    {
	xl += p.x();
	yl += p.y();
    }

    void printOn(ostream& strm = cout) const;

};

void PS_lineto::printOn(ostream& strm) const
{
    strm << xl << " mm "  << yl << " mm lineto";
}

ostream& operator<<(ostream& strm, const PS_lineto& p)
{
    p.printOn(strm);
    return strm;
}


class PS_moveto: public Point
{
    double xl,yl;          // x-y coordinates

friend ostream& operator<<(ostream&, const PS_moveto& );

public:
    PS_moveto()                                 { xl = yl = 0; }
    PS_moveto(double newx, double newy)         { xl = newx; yl = newy; }
    PS_moveto(const Point& p)	                { xl = p.x(); yl = p.y(); }

    void operator=(const Point& p)              { xl = p.x(); yl = p.y(); }

//    PS_moveto operator=(const Point& p)  //   { xl = p.x(); yl = p.y(); }
  //				{ return PS_moveto(p.x(),p.y());}

    PS_moveto operator+(const PS_moveto& p)
      			        { return PS_moveto(xl + p.xl, yl + p.yl);}

    void operator+=(const Point& p)
    {
	xl += p.x();
	yl += p.y();
    }

    void printOn(ostream& strm = cout) const;

};

void PS_moveto::printOn(ostream& strm) const
{
    strm << xl << " mm "  << yl << " mm moveto";
}

ostream& operator<<(ostream& strm, const PS_moveto& p)
{
    p.printOn(strm);
    return strm;
}


class PS_translate: public Point
{
    double xl,yl;          // x-y coordinates

friend ostream& operator<<(ostream&, const PS_translate& );

public:
    PS_translate()                           { xl = yl = 0; }
    PS_translate(double newx, double newy)   { xl = newx; yl = newy; }
    PS_translate(const Point& p)	     { xl = p.x(); yl = p.y(); }

    void operator=(const Point& p)           { xl = p.x(); yl = p.y(); }
  //				{ return PS_translate(p.x(),p.y());}

    PS_translate operator+(const PS_translate& p)
				{ return PS_translate(xl + p.xl, yl + p.yl);}

    void operator+=(const Point& p)
    {
	xl += p.x();
	yl += p.y();
    }

    void printOn(ostream& strm = cout) const;

};

void PS_translate::printOn(ostream& strm) const
{
    strm << xl << " mm "  << yl << " mm translate ";
}

ostream& operator<<(ostream& strm, const PS_translate& p)
{
    p.printOn(strm);
    return strm;
}


class PS_dashline1: public Point
{
    double xl,yl;          // x-y coordinates

friend ostream& operator<<(ostream&, const PS_dashline1& );

public:
    PS_dashline1()                          { xl = yl = 0; }
    PS_dashline1(double newx, double newy)  { xl = newx; yl = newy; }
    PS_dashline1(const Point& p)	    { xl = p.x(); yl = p.y(); }

    void operator=(const Point& p)          { xl = p.x(); yl = p.y(); }

//    PS_dashline1 operator=(const Point& p)  //  { xl = p.x(); yl = p.y(); }
  //				{ return PS_dashline1(p.x(),p.y());}

    PS_dashline1 operator+(const PS_dashline1& p)
      			        { return PS_dashline1(xl + p.xl, yl + p.yl);}

    void operator+=(const Point& p)
    {
	xl += p.x();
	yl += p.y();
    }

    void printOn(ostream& strm = cout) const;

};

void PS_dashline1::printOn(ostream& strm) const
{
    strm << xl << " mm "  << yl << " mm [8 4 8 4 3 3 3 3 3 15] lp";
}

ostream& operator<<(ostream& strm, const PS_dashline1& p)
{
    p.printOn(strm);
    return strm;
}


class PS_dashline: public Point
{
    double x1,y1,x2,y2;          // x-y coordinates

friend ostream& operator<<(ostream&, const PS_dashline& );

public:
    PS_dashline()                           { x1 = y1 = 0; }
    PS_dashline(double newx, double newy)   { x1 = y1 = 0; 
                                              x2 = newx; y2 = newy; }
    PS_dashline(const Point& p)	            { x1 = y1 = 0; 
                                              x2 = p.x(); y2 = p.y(); }
    PS_dashline(double newx1, double newy1, double newx2, double newy2)   
                                            { x1 = newx1; y1 = newy1;
                                              x2 = newx2; y2 = newy2; }
    PS_dashline(const Point& p1, const Point& p2)	    
                                            { x1 = p1.x(); y1 = p1.y();
                                              x2 = p2.x(); y2 = p2.y(); }
    PS_dashline(double newx1, double newy1, const Point& p)
                                            { x1 = newx1; y1 = newy1;
                                              x2 = p.x(); y2 = p.y(); }
    PS_dashline(const Point& p, double newx2, double newy2)   
                                            { x1 = p.x(); y1 = p.y(); 
                                              x2 = newx2; y2 = newy2; }
        

    void printOn(ostream& strm = cout) const;

};

void PS_dashline::printOn(ostream& strm) const
{
    strm << x1 << " mm " << y1 << " mm " << x2 << " mm "
         << y2 << " mm [8 4 8 4 3 3 3 3 3 15] lp";
}

ostream& operator<<(ostream& strm, const PS_dashline& p)
{
    p.printOn(strm);
    return strm;
}

