/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.CloseableIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;

public class DownsamplingIterator
implements CloseableIterator<SAMRecord>,
Iterable<SAMRecord> {
    private final Iterator<SAMRecord> underlyingIterator;
    private final Random random;
    private final double probabilityOfKeeping;
    private SAMRecord nextRecord;
    private long totalReads;
    private long keptReads;
    private final Map<String, Boolean> decisions = new HashMap<String, Boolean>();
    private boolean allowSecondaryAlignments = false;
    private boolean allowSupplementalAlignments = false;
    private boolean includeNoRefReads = true;

    public DownsamplingIterator(Iterator<SAMRecord> iterator, Random random, double probabilityOfKeeping) {
        this.underlyingIterator = iterator;
        this.random = random;
        this.probabilityOfKeeping = probabilityOfKeeping;
    }

    public DownsamplingIterator setAllowSecondaryAlignments(boolean allowSecondaryAlignments) {
        this.allowSecondaryAlignments = allowSecondaryAlignments;
        return this;
    }

    public DownsamplingIterator setAllowSupplementalAlignments(boolean allowSupplementalAlignments) {
        this.allowSupplementalAlignments = allowSupplementalAlignments;
        return this;
    }

    public DownsamplingIterator setIncludeNoRefReads(boolean includeNoRefReads) {
        this.includeNoRefReads = includeNoRefReads;
        return this;
    }

    public long getTotalReads() {
        return this.totalReads;
    }

    public long getKeptReads() {
        return this.keptReads;
    }

    @Override
    public Iterator<SAMRecord> iterator() {
        return this;
    }

    private boolean advance() {
        boolean oneRecPerRead;
        this.nextRecord = null;
        boolean bl = oneRecPerRead = !this.allowSecondaryAlignments && !this.allowSupplementalAlignments;
        while (this.nextRecord == null && this.underlyingIterator.hasNext()) {
            boolean keeper;
            Boolean previous;
            SAMRecord rec = this.underlyingIterator.next();
            if (!this.allowSecondaryAlignments && rec.getNotPrimaryAlignmentFlag() || !this.allowSupplementalAlignments && rec.getSupplementaryAlignmentFlag()) continue;
            if (!this.includeNoRefReads && rec.getReferenceIndex() == -1) break;
            ++this.totalReads;
            String key = rec.getReadName();
            Boolean bl2 = previous = oneRecPerRead ? this.decisions.remove(key) : this.decisions.get(key);
            if (previous == null) {
                boolean bl3 = keeper = this.random.nextDouble() <= this.probabilityOfKeeping;
                if (rec.getReadPairedFlag() || this.allowSecondaryAlignments || this.allowSupplementalAlignments) {
                    this.decisions.put(key, keeper);
                }
            } else {
                keeper = previous;
            }
            if (!keeper) continue;
            this.nextRecord = rec;
            ++this.keptReads;
        }
        return this.nextRecord != null;
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null || this.advance();
    }

    @Override
    public SAMRecord next() {
        if (this.nextRecord == null) {
            throw new NoSuchElementException("Call to next() when hasNext() == false");
        }
        SAMRecord retval = this.nextRecord;
        this.advance();
        return retval;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported.");
    }

    @Override
    public void close() {
    }
}

