!===============================================================================
! Copyright 2005-2019 Intel Corporation.
!
! This software and the related documents are Intel copyrighted  materials,  and
! your use of  them is  governed by the  express license  under which  they were
! provided to you (License).  Unless the License provides otherwise, you may not
! use, modify, copy, publish, distribute,  disclose or transmit this software or
! the related documents without Intel's prior written permission.
!
! This software and the related documents  are provided as  is,  with no express
! or implied  warranties,  other  than those  that are  expressly stated  in the
! License.
!===============================================================================

!  Content:
!       Intel(R) MKL BLAS77 interface as prototypes for
!       Intel(R) MKL BLAS95 interfaces
!
!*******************************************************************************


MODULE F77_BLAS

INTERFACE F77_XERBLA
  PURE SUBROUTINE XERBLA(NAME,INFO)
    CHARACTER(LEN=*), INTENT(IN) :: NAME
    INTEGER, INTENT(IN) :: INFO
  END SUBROUTINE XERBLA
END INTERFACE F77_XERBLA

! BLAS level 1
INTERFACE F77_ASUM
  PURE FUNCTION SASUM(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP) :: SASUM
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION SASUM
  PURE FUNCTION SCASUM(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP) :: SCASUM
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION SCASUM
  PURE FUNCTION DASUM(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP) :: DASUM
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION DASUM
  PURE FUNCTION DZASUM(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP) :: DZASUM
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION DZASUM
END INTERFACE F77_ASUM

INTERFACE F77_AXPY
  PURE SUBROUTINE SAXPY(N,A,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SAXPY
  PURE SUBROUTINE DAXPY(N,A,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DAXPY
  PURE SUBROUTINE CAXPY(N,A,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CAXPY
  PURE SUBROUTINE ZAXPY(N,A,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZAXPY
END INTERFACE F77_AXPY

INTERFACE F77_COPY
  PURE SUBROUTINE SCOPY(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SCOPY
  PURE SUBROUTINE DCOPY(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DCOPY
  PURE SUBROUTINE CCOPY(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CCOPY
  PURE SUBROUTINE ZCOPY(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZCOPY
END INTERFACE F77_COPY

INTERFACE F77_DOT
  PURE FUNCTION SDOT(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP) :: SDOT
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END FUNCTION SDOT
  PURE FUNCTION DDOT(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP) :: DDOT
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END FUNCTION DDOT
END INTERFACE F77_DOT

INTERFACE F77_SDOT
  PURE FUNCTION SDSDOT(N,SB,SX,INCX,SY,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP) :: SDSDOT
    REAL(WP), INTENT(IN) :: SX(*)
    REAL(WP), INTENT(IN) :: SY(*)
    REAL(WP), INTENT(IN) :: SB
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END FUNCTION SDSDOT
  PURE FUNCTION DSDOT(N,SX,INCX,SY,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    INTEGER, PARAMETER :: SP = KIND(1.0E0)
    REAL(WP) :: DSDOT
    REAL(SP), INTENT(IN) :: SX(*)
    REAL(SP), INTENT(IN) :: SY(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END FUNCTION DSDOT
END INTERFACE F77_SDOT

INTERFACE F77_DOTC
  PURE FUNCTION CDOTC(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP) :: CDOTC
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END FUNCTION CDOTC
  PURE FUNCTION ZDOTC(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP) :: ZDOTC
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END FUNCTION ZDOTC
END INTERFACE F77_DOTC

INTERFACE F77_DOTU
  PURE FUNCTION CDOTU(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP) :: CDOTU
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END FUNCTION CDOTU
  PURE FUNCTION ZDOTU(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP) :: ZDOTU
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END FUNCTION ZDOTU
END INTERFACE F77_DOTU

INTERFACE F77_NRM2
  PURE FUNCTION SNRM2(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP) :: SNRM2
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION SNRM2
  PURE FUNCTION DNRM2(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP) :: DNRM2
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION DNRM2
  PURE FUNCTION SCNRM2(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP) :: SCNRM2
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION SCNRM2
  PURE FUNCTION DZNRM2(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP) :: DZNRM2
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION DZNRM2
END INTERFACE F77_NRM2

INTERFACE F77_ROT
  PURE SUBROUTINE SROT(N,X,INCX,Y,INCY,C,S)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: C
    REAL(WP), INTENT(IN) :: S
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SROT
  PURE SUBROUTINE DROT(N,X,INCX,Y,INCY,C,S)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: C
    REAL(WP), INTENT(IN) :: S
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DROT
  PURE SUBROUTINE CSROT(N,X,INCX,Y,INCY,C,S)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: C
    REAL(WP), INTENT(IN) :: S
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CSROT
  PURE SUBROUTINE ZDROT(N,X,INCX,Y,INCY,C,S)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: C
    REAL(WP), INTENT(IN) :: S
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZDROT
END INTERFACE F77_ROT

INTERFACE F77_ROTG
  PURE SUBROUTINE SROTG(A,B,C,S)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A
    REAL(WP), INTENT(INOUT) :: B
    REAL(WP), INTENT(OUT) :: C
    REAL(WP), INTENT(OUT) :: S
  END SUBROUTINE SROTG
  PURE SUBROUTINE DROTG(A,B,C,S)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A
    REAL(WP), INTENT(INOUT) :: B
    REAL(WP), INTENT(OUT) :: C
    REAL(WP), INTENT(OUT) :: S
  END SUBROUTINE DROTG
  PURE SUBROUTINE CROTG(A,B,C,S)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A
    COMPLEX(WP), INTENT(INOUT) :: B
    REAL(WP), INTENT(OUT) :: C
    COMPLEX(WP), INTENT(OUT) :: S
  END SUBROUTINE CROTG
  PURE SUBROUTINE ZROTG(A,B,C,S)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A
    COMPLEX(WP), INTENT(INOUT) :: B
    REAL(WP), INTENT(OUT) :: C
    COMPLEX(WP), INTENT(OUT) :: S
  END SUBROUTINE ZROTG
END INTERFACE F77_ROTG

INTERFACE F77_ROTM
  PURE SUBROUTINE SROTM(N,X,INCX,Y,INCY,PARAM)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: PARAM(5)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SROTM
  PURE SUBROUTINE DROTM(N,X,INCX,Y,INCY,PARAM)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: PARAM(5)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DROTM
END INTERFACE F77_ROTM

INTERFACE F77_ROTMG
  PURE SUBROUTINE SROTMG(D1,D2,X1,Y1,PARAM)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: D1
    REAL(WP), INTENT(INOUT) :: D2
    REAL(WP), INTENT(INOUT) :: X1
    REAL(WP), INTENT(IN) :: Y1
    REAL(WP), INTENT(OUT) :: PARAM(5)
  END SUBROUTINE SROTMG
  PURE SUBROUTINE DROTMG(D1,D2,X1,Y1,PARAM)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: D1
    REAL(WP), INTENT(INOUT) :: D2
    REAL(WP), INTENT(INOUT) :: X1
    REAL(WP), INTENT(IN) :: Y1
    REAL(WP), INTENT(OUT) :: PARAM(5)
  END SUBROUTINE DROTMG
END INTERFACE F77_ROTMG

INTERFACE F77_SCAL
  PURE SUBROUTINE SSCAL(N,A,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SSCAL
  PURE SUBROUTINE DSCAL(N,A,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DSCAL
  PURE SUBROUTINE CSCAL(N,A,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    COMPLEX(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CSCAL
  PURE SUBROUTINE ZSCAL(N,A,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    COMPLEX(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZSCAL
  PURE SUBROUTINE CSSCAL(N,A,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CSSCAL
  PURE SUBROUTINE ZDSCAL(N,A,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZDSCAL
END INTERFACE F77_SCAL

INTERFACE F77_SWAP
  PURE SUBROUTINE SSWAP(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SSWAP
  PURE SUBROUTINE DSWAP(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DSWAP
  PURE SUBROUTINE CSWAP(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CSWAP
  PURE SUBROUTINE ZSWAP(N,X,INCX,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZSWAP
END INTERFACE F77_SWAP

INTERFACE F77_IAMAX
  PURE FUNCTION ISAMAX(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    INTEGER :: ISAMAX
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION ISAMAX
  PURE FUNCTION IDAMAX(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    INTEGER :: IDAMAX
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION IDAMAX
  PURE FUNCTION ICAMAX(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    INTEGER :: ICAMAX
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION ICAMAX
  PURE FUNCTION IZAMAX(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    INTEGER :: IZAMAX
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION IZAMAX
END INTERFACE F77_IAMAX

INTERFACE F77_IAMIN
  PURE FUNCTION ISAMIN(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    INTEGER :: ISAMIN
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION ISAMIN
  PURE FUNCTION IDAMIN(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    INTEGER :: IDAMIN
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION IDAMIN
  PURE FUNCTION ICAMIN(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    INTEGER :: ICAMIN
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION ICAMIN
  PURE FUNCTION IZAMIN(N,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    INTEGER :: IZAMIN
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END FUNCTION IZAMIN
END INTERFACE F77_IAMIN

INTERFACE F77_CABS1
  PURE FUNCTION SCABS1(C)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP) :: SCABS1
    COMPLEX(WP), INTENT(IN) :: C
  END FUNCTION SCABS1
  PURE FUNCTION DCABS1(Z)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP) :: DCABS1
    COMPLEX(WP), INTENT(IN) :: Z
  END FUNCTION DCABS1
END INTERFACE F77_CABS1

INTERFACE F77_GBMV
  PURE SUBROUTINE SGBMV(TRANS,M,N,KL,KU,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SGBMV
  PURE SUBROUTINE DGBMV(TRANS,M,N,KL,KU,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DGBMV
  PURE SUBROUTINE CGBMV(TRANS,M,N,KL,KU,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CGBMV
  PURE SUBROUTINE ZGBMV(TRANS,M,N,KL,KU,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: KL
    INTEGER, INTENT(IN) :: M
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: KU
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZGBMV
END INTERFACE F77_GBMV

INTERFACE F77_GEMV
  PURE SUBROUTINE SGEMV(TRANS,M,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SGEMV
  PURE SUBROUTINE DGEMV(TRANS,M,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DGEMV
  PURE SUBROUTINE CGEMV(TRANS,M,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CGEMV
  PURE SUBROUTINE ZGEMV(TRANS,M,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZGEMV
  PURE SUBROUTINE SCGEMV(TRANS,M,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SCGEMV
  PURE SUBROUTINE DZGEMV(TRANS,M,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DZGEMV
END INTERFACE F77_GEMV

INTERFACE F77_GER
  PURE SUBROUTINE SGER(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(IN) :: Y(*)
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SGER
  PURE SUBROUTINE DGER(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(IN) :: Y(*)
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DGER
END INTERFACE F77_GER

INTERFACE F77_GERC
  PURE SUBROUTINE CGERC(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CGERC
  PURE SUBROUTINE ZGERC(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZGERC
END INTERFACE F77_GERC

INTERFACE F77_GERU
  PURE SUBROUTINE CGERU(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CGERU
  PURE SUBROUTINE ZGERU(M,N,ALPHA,X,INCX,Y,INCY,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZGERU
END INTERFACE F77_GERU

INTERFACE F77_HBMV
  PURE SUBROUTINE CHBMV(UPLO,N,K,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CHBMV
  PURE SUBROUTINE ZHBMV(UPLO,N,K,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZHBMV
END INTERFACE F77_HBMV

INTERFACE F77_HEMV
  PURE SUBROUTINE CHEMV(UPLO,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CHEMV
  PURE SUBROUTINE ZHEMV(UPLO,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZHEMV
END INTERFACE F77_HEMV

INTERFACE F77_HER
  PURE SUBROUTINE CHER(UPLO,N,ALPHA,X,INCX,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CHER
  PURE SUBROUTINE ZHER(UPLO,N,ALPHA,X,INCX,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZHER
END INTERFACE F77_HER

INTERFACE F77_HER2
  PURE SUBROUTINE CHER2(UPLO,N,ALPHA,X,INCX,Y,INCY,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CHER2
  PURE SUBROUTINE ZHER2(UPLO,N,ALPHA,X,INCX,Y,INCY,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZHER2
END INTERFACE F77_HER2

INTERFACE F77_HPMV
  PURE SUBROUTINE CHPMV(UPLO,N,ALPHA,AP,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CHPMV
  PURE SUBROUTINE ZHPMV(UPLO,N,ALPHA,AP,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZHPMV
END INTERFACE F77_HPMV

INTERFACE F77_HPR
  PURE SUBROUTINE CHPR(UPLO,N,ALPHA,X,INCX,AP)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CHPR
  PURE SUBROUTINE ZHPR(UPLO,N,ALPHA,X,INCX,AP)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZHPR
END INTERFACE F77_HPR

INTERFACE F77_HPR2
  PURE SUBROUTINE CHPR2(UPLO,N,ALPHA,X,INCX,Y,INCY,AP)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CHPR2
  PURE SUBROUTINE ZHPR2(UPLO,N,ALPHA,X,INCX,Y,INCY,AP)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(INOUT) :: AP(*)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZHPR2
END INTERFACE F77_HPR2

INTERFACE F77_SBMV
  PURE SUBROUTINE SSBMV(UPLO,N,K,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SSBMV
  PURE SUBROUTINE DSBMV(UPLO,N,K,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DSBMV
END INTERFACE F77_SBMV

INTERFACE F77_SPMV
  PURE SUBROUTINE SSPMV(UPLO,N,ALPHA,AP,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SSPMV
  PURE SUBROUTINE DSPMV(UPLO,N,ALPHA,AP,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DSPMV
END INTERFACE F77_SPMV

INTERFACE F77_SPR
  PURE SUBROUTINE SSPR(UPLO,N,ALPHA,X,INCX,AP)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SSPR
  PURE SUBROUTINE DSPR(UPLO,N,ALPHA,X,INCX,AP)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DSPR
END INTERFACE F77_SPR

INTERFACE F77_SPR2
  PURE SUBROUTINE SSPR2(UPLO,N,ALPHA,X,INCX,Y,INCY,AP)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(IN) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SSPR2
  PURE SUBROUTINE DSPR2(UPLO,N,ALPHA,X,INCX,Y,INCY,AP)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: AP(*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(IN) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DSPR2
END INTERFACE F77_SPR2

INTERFACE F77_SYMV
  PURE SUBROUTINE SSYMV(UPLO,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SSYMV
  PURE SUBROUTINE DSYMV(UPLO,N,ALPHA,A,LDA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DSYMV
END INTERFACE F77_SYMV

INTERFACE F77_SYR
  PURE SUBROUTINE SSYR(UPLO,N,ALPHA,X,INCX,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SSYR
  PURE SUBROUTINE DSYR(UPLO,N,ALPHA,X,INCX,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DSYR
END INTERFACE F77_SYR

INTERFACE F77_SYR2
  PURE SUBROUTINE SSYR2(UPLO,N,ALPHA,X,INCX,Y,INCY,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(IN) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SSYR2
  PURE SUBROUTINE DSYR2(UPLO,N,ALPHA,X,INCX,Y,INCY,A,LDA)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(IN) :: Y(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DSYR2
END INTERFACE F77_SYR2

INTERFACE F77_TBMV
  PURE SUBROUTINE STBMV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE STBMV
  PURE SUBROUTINE DTBMV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DTBMV
  PURE SUBROUTINE CTBMV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CTBMV
  PURE SUBROUTINE ZTBMV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZTBMV
END INTERFACE F77_TBMV

INTERFACE F77_TBSV
  PURE SUBROUTINE STBSV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE STBSV
  PURE SUBROUTINE DTBSV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DTBSV
  PURE SUBROUTINE CTBSV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CTBSV
  PURE SUBROUTINE ZTBSV(UPLO,TRANS,DIAG,N,K,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZTBSV
END INTERFACE F77_TBSV

INTERFACE F77_TPMV
  PURE SUBROUTINE STPMV(UPLO,TRANS,DIAG,N,AP,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE STPMV
  PURE SUBROUTINE DTPMV(UPLO,TRANS,DIAG,N,AP,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DTPMV
  PURE SUBROUTINE CTPMV(UPLO,TRANS,DIAG,N,AP,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CTPMV
  PURE SUBROUTINE ZTPMV(UPLO,TRANS,DIAG,N,AP,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZTPMV
END INTERFACE F77_TPMV

INTERFACE F77_TPSV
  PURE SUBROUTINE STPSV(UPLO,TRANS,DIAG,N,AP,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE STPSV
  PURE SUBROUTINE DTPSV(UPLO,TRANS,DIAG,N,AP,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: AP(*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DTPSV
  PURE SUBROUTINE CTPSV(UPLO,TRANS,DIAG,N,AP,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CTPSV
  PURE SUBROUTINE ZTPSV(UPLO,TRANS,DIAG,N,AP,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: AP(*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZTPSV
END INTERFACE F77_TPSV

INTERFACE F77_TRMV
  PURE SUBROUTINE STRMV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE STRMV
  PURE SUBROUTINE DTRMV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DTRMV
  PURE SUBROUTINE CTRMV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CTRMV
  PURE SUBROUTINE ZTRMV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZTRMV
END INTERFACE F77_TRMV

INTERFACE F77_TRSV
  PURE SUBROUTINE STRSV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE STRSV
  PURE SUBROUTINE DTRSV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DTRSV
  PURE SUBROUTINE CTRSV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CTRSV
  PURE SUBROUTINE ZTRSV(UPLO,TRANS,DIAG,N,A,LDA,X,INCX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: X(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZTRSV
END INTERFACE F77_TRSV

INTERFACE F77_GEMM
  PURE SUBROUTINE SGEMM(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,   &
     &                                                              LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE SGEMM
  PURE SUBROUTINE DGEMM(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,   &
     &                                                              LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE DGEMM
  PURE SUBROUTINE CGEMM(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,   &
     &                                                              LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE CGEMM
  PURE SUBROUTINE ZGEMM(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,   &
     &                                                              LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE ZGEMM
  PURE SUBROUTINE SCGEMM(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,  &
     &                                                              LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE SCGEMM
  PURE SUBROUTINE DZGEMM(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,  &
     &                                                              LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE DZGEMM
END INTERFACE F77_GEMM

INTERFACE F77_HEMM
  PURE SUBROUTINE CHEMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE CHEMM
  PURE SUBROUTINE ZHEMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE ZHEMM
END INTERFACE F77_HEMM

INTERFACE F77_HERK
  PURE SUBROUTINE CHERK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE CHERK
  PURE SUBROUTINE ZHERK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE ZHERK
END INTERFACE F77_HERK

INTERFACE F77_HER2K
  PURE SUBROUTINE CHER2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    COMPLEX(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE CHER2K
  PURE SUBROUTINE ZHER2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    COMPLEX(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE ZHER2K
END INTERFACE F77_HER2K

INTERFACE F77_SYMM
  PURE SUBROUTINE SSYMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE SSYMM
  PURE SUBROUTINE DSYMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE DSYMM
  PURE SUBROUTINE CSYMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE CSYMM
  PURE SUBROUTINE ZSYMM(SIDE,UPLO,M,N,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE ZSYMM
END INTERFACE F77_SYMM

INTERFACE F77_SYRK
  PURE SUBROUTINE SSYRK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE SSYRK
  PURE SUBROUTINE DSYRK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE DSYRK
  PURE SUBROUTINE CSYRK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE CSYRK
  PURE SUBROUTINE ZSYRK(UPLO,TRANS,N,K,ALPHA,A,LDA,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE ZSYRK
END INTERFACE F77_SYRK

INTERFACE F77_SYR2K
  PURE SUBROUTINE SSYR2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE SSYR2K
  PURE SUBROUTINE DSYR2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE DSYR2K
  PURE SUBROUTINE CSYR2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE CSYR2K
  PURE SUBROUTINE ZSYR2K(UPLO,TRANS,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANS
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE ZSYR2K
END INTERFACE F77_SYR2K

INTERFACE F77_TRMM
  PURE SUBROUTINE STRMM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE STRMM
  PURE SUBROUTINE DTRMM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DTRMM
  PURE SUBROUTINE CTRMM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CTRMM
  PURE SUBROUTINE ZTRMM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZTRMM
END INTERFACE F77_TRMM

INTERFACE F77_TRSM
  PURE SUBROUTINE STRSM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE STRSM
  PURE SUBROUTINE DTRSM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    REAL(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE DTRSM
  PURE SUBROUTINE CTRSM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE CTRSM
  PURE SUBROUTINE ZTRSM(SIDE,UPLO,TRANSA,DIAG,M,N,ALPHA,A,LDA,B,LDB)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(INOUT) :: B(LDB,*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: DIAG
    COMPLEX(WP), INTENT(IN) :: ALPHA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
  END SUBROUTINE ZTRSM
END INTERFACE F77_TRSM

INTERFACE F77_AXPYI
  PURE SUBROUTINE SAXPYI(NZ,A,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE SAXPYI
  PURE SUBROUTINE DAXPYI(NZ,A,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE DAXPYI
  PURE SUBROUTINE CAXPYI(NZ,A,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE CAXPYI
  PURE SUBROUTINE ZAXPYI(NZ,A,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: A
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE ZAXPYI
END INTERFACE F77_AXPYI

INTERFACE F77_DOTI
  PURE FUNCTION SDOTI(NZ,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP) :: SDOTI
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END FUNCTION SDOTI
  PURE FUNCTION DDOTI(NZ,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP) :: DDOTI
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END FUNCTION DDOTI
END INTERFACE F77_DOTI

INTERFACE F77_DOTCI
  PURE FUNCTION CDOTCI(NZ,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP) :: CDOTCI
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END FUNCTION CDOTCI
  PURE FUNCTION ZDOTCI(NZ,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP) :: ZDOTCI
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END FUNCTION ZDOTCI
END INTERFACE F77_DOTCI

INTERFACE F77_DOTUI
  PURE FUNCTION CDOTUI(NZ,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP) :: CDOTUI
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END FUNCTION CDOTUI
  PURE FUNCTION ZDOTUI(NZ,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP) :: ZDOTUI
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END FUNCTION ZDOTUI
END INTERFACE F77_DOTUI

INTERFACE F77_GTHR
  PURE SUBROUTINE SGTHR(NZ,Y,X,INDX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE SGTHR
  PURE SUBROUTINE DGTHR(NZ,Y,X,INDX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE DGTHR
  PURE SUBROUTINE CGTHR(NZ,Y,X,INDX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE CGTHR
  PURE SUBROUTINE ZGTHR(NZ,Y,X,INDX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(IN) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE ZGTHR
END INTERFACE F77_GTHR

INTERFACE F77_GTHRZ
  PURE SUBROUTINE SGTHRZ(NZ,Y,X,INDX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE SGTHRZ
  PURE SUBROUTINE DGTHRZ(NZ,Y,X,INDX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE DGTHRZ
  PURE SUBROUTINE CGTHRZ(NZ,Y,X,INDX)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE CGTHRZ
  PURE SUBROUTINE ZGTHRZ(NZ,Y,X,INDX)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(OUT) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE ZGTHRZ
END INTERFACE F77_GTHRZ

INTERFACE F77_ROTI
  PURE SUBROUTINE SROTI(NZ,X,INDX,Y,C,S)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(INOUT) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(IN) :: Y(*)
    REAL(WP), INTENT(IN) :: C
    REAL(WP), INTENT(IN) :: S
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE SROTI
  PURE SUBROUTINE DROTI(NZ,X,INDX,Y,C,S)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(INOUT) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(IN) :: Y(*)
    REAL(WP), INTENT(IN) :: C
    REAL(WP), INTENT(IN) :: S
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE DROTI
END INTERFACE F77_ROTI

INTERFACE F77_SCTR
  PURE SUBROUTINE SSCTR(NZ,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(OUT) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE SSCTR
  PURE SUBROUTINE DSCTR(NZ,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    REAL(WP), INTENT(OUT) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE DSCTR
  PURE SUBROUTINE CSCTR(NZ,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(OUT) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE CSCTR
  PURE SUBROUTINE ZSCTR(NZ,X,INDX,Y)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: X(*)
    INTEGER, INTENT(IN) :: INDX(*)
    COMPLEX(WP), INTENT(OUT) :: Y(*)
    INTEGER, INTENT(IN) :: NZ
  END SUBROUTINE ZSCTR
END INTERFACE F77_SCTR

INTERFACE F77_GEMM3M
  PURE SUBROUTINE CGEMM3M(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C, &
     &                                                              LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE CGEMM3M
  PURE SUBROUTINE ZGEMM3M(TRANSA,TRANSB,M,N,K,ALPHA,A,LDA,B,LDB,BETA,C, &
     &                                                              LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE ZGEMM3M
END INTERFACE F77_GEMM3M

INTERFACE F77_GEMMT
  PURE SUBROUTINE SGEMMT(UPLO,TRANSA,TRANSB,N,K,ALPHA,A,LDA,B,LDB,BETA, &
     &                                                            C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE SGEMMT
  PURE SUBROUTINE DGEMMT(UPLO,TRANSA,TRANSB,N,K,ALPHA,A,LDA,B,LDB,BETA, &
     &                                                            C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: B(LDB,*)
    REAL(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE DGEMMT
  PURE SUBROUTINE CGEMMT(UPLO,TRANSA,TRANSB,N,K,ALPHA,A,LDA,B,LDB,BETA, &
     &                                                            C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE CGEMMT
  PURE SUBROUTINE ZGEMMT(UPLO,TRANSA,TRANSB,N,K,ALPHA,A,LDA,B,LDB,BETA, &
     &                                                            C,LDC)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: B(LDB,*)
    COMPLEX(WP), INTENT(INOUT) :: C(LDC,*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: K
    INTEGER, INTENT(IN) :: LDA
    INTEGER, INTENT(IN) :: LDB
    INTEGER, INTENT(IN) :: LDC
  END SUBROUTINE ZGEMMT
END INTERFACE F77_GEMMT

INTERFACE F77_AXPBY
  PURE SUBROUTINE SAXPBY(N,ALPHA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE SAXPBY
  PURE SUBROUTINE DAXPBY(N,ALPHA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: X(*)
    REAL(WP), INTENT(INOUT) :: Y(*)
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE DAXPBY
  PURE SUBROUTINE CAXPBY(N,ALPHA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE CAXPBY
  PURE SUBROUTINE ZAXPBY(N,ALPHA,X,INCX,BETA,Y,INCY)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: X(*)
    COMPLEX(WP), INTENT(INOUT) :: Y(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX
    INTEGER, INTENT(IN) :: INCY
    INTEGER, INTENT(IN) :: N
  END SUBROUTINE ZAXPBY
END INTERFACE F77_AXPBY

INTERFACE F77_GEM2V
  PURE SUBROUTINE SGEM2VU(M,N,ALPHA,A,LDA,X1,INCX1,X2,INCX2,BETA,Y1,    &
     &                                                   INCY1,Y2,INCY2)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X1(*)
    REAL(WP), INTENT(IN) :: X2(*)
    REAL(WP), INTENT(INOUT) :: Y1(*)
    REAL(WP), INTENT(INOUT) :: Y2(*)
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX1
    INTEGER, INTENT(IN) :: INCX2
    INTEGER, INTENT(IN) :: INCY1
    INTEGER, INTENT(IN) :: INCY2
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE SGEM2VU
  PURE SUBROUTINE DGEM2VU(M,N,ALPHA,A,LDA,X1,INCX1,X2,INCX2,BETA,Y1,    &
     &                                                   INCY1,Y2,INCY2)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    REAL(WP), INTENT(IN) :: A(LDA,*)
    REAL(WP), INTENT(IN) :: X1(*)
    REAL(WP), INTENT(IN) :: X2(*)
    REAL(WP), INTENT(INOUT) :: Y1(*)
    REAL(WP), INTENT(INOUT) :: Y2(*)
    REAL(WP), INTENT(IN) :: ALPHA
    REAL(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX1
    INTEGER, INTENT(IN) :: INCX2
    INTEGER, INTENT(IN) :: INCY1
    INTEGER, INTENT(IN) :: INCY2
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE DGEM2VU
  PURE SUBROUTINE CGEM2VC(M,N,ALPHA,A,LDA,X1,INCX1,X2,INCX2,BETA,Y1,    &
     &                                                   INCY1,Y2,INCY2)
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X1(*)
    COMPLEX(WP), INTENT(IN) :: X2(*)
    COMPLEX(WP), INTENT(INOUT) :: Y1(*)
    COMPLEX(WP), INTENT(INOUT) :: Y2(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX1
    INTEGER, INTENT(IN) :: INCX2
    INTEGER, INTENT(IN) :: INCY1
    INTEGER, INTENT(IN) :: INCY2
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE CGEM2VC
  PURE SUBROUTINE ZGEM2VC(M,N,ALPHA,A,LDA,X1,INCX1,X2,INCX2,BETA,Y1,    &
     &                                                   INCY1,Y2,INCY2)
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    COMPLEX(WP), INTENT(IN) :: A(LDA,*)
    COMPLEX(WP), INTENT(IN) :: X1(*)
    COMPLEX(WP), INTENT(IN) :: X2(*)
    COMPLEX(WP), INTENT(INOUT) :: Y1(*)
    COMPLEX(WP), INTENT(INOUT) :: Y2(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA
    COMPLEX(WP), INTENT(IN) :: BETA
    INTEGER, INTENT(IN) :: INCX1
    INTEGER, INTENT(IN) :: INCX2
    INTEGER, INTENT(IN) :: INCY1
    INTEGER, INTENT(IN) :: INCY2
    INTEGER, INTENT(IN) :: M
    INTEGER, INTENT(IN) :: N
    INTEGER, INTENT(IN) :: LDA
  END SUBROUTINE ZGEM2VC
END INTERFACE F77_GEM2V

INTERFACE F77_GEMM_BATCH
  PURE SUBROUTINE SGEMM_BATCH(TRANSA_ARRAY,TRANSB_ARRAY,M_ARRAY,N_ARRAY,&
     &                        K_ARRAY,ALPHA_ARRAY,A_ARRAY,LDA_ARRAY,    &
     &                        B_ARRAY,LDB_ARRAY,BETA_ARRAY,C_ARRAY,     &
     &                        LDC_ARRAY,GROUP_COUNT,GROUP_SIZE)
    use, intrinsic :: ISO_C_BINDING
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: A_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: B_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(INOUT) :: C_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB_ARRAY(*)
    REAL(WP), INTENT(IN) :: ALPHA_ARRAY(*)
    REAL(WP), INTENT(IN) :: BETA_ARRAY(*)
    INTEGER, INTENT(IN) :: M_ARRAY(*)
    INTEGER, INTENT(IN) :: N_ARRAY(*)
    INTEGER, INTENT(IN) :: K_ARRAY(*)
    INTEGER, INTENT(IN) :: LDA_ARRAY(*)
    INTEGER, INTENT(IN) :: LDB_ARRAY(*)
    INTEGER, INTENT(IN) :: LDC_ARRAY(*)
    INTEGER, INTENT(IN) :: GROUP_COUNT
    INTEGER, INTENT(IN) :: GROUP_SIZE(*)
  END SUBROUTINE SGEMM_BATCH
  PURE SUBROUTINE DGEMM_BATCH(TRANSA_ARRAY,TRANSB_ARRAY,M_ARRAY,N_ARRAY,&
     &                        K_ARRAY,ALPHA_ARRAY,A_ARRAY,LDA_ARRAY,    &
     &                        B_ARRAY,LDB_ARRAY,BETA_ARRAY,C_ARRAY,     &
     &                        LDC_ARRAY,GROUP_COUNT,GROUP_SIZE)
    use, intrinsic :: ISO_C_BINDING
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: A_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: B_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(INOUT) :: C_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB_ARRAY(*)
    REAL(WP), INTENT(IN) :: ALPHA_ARRAY(*)
    REAL(WP), INTENT(IN) :: BETA_ARRAY(*)
    INTEGER, INTENT(IN) :: M_ARRAY(*)
    INTEGER, INTENT(IN) :: N_ARRAY(*)
    INTEGER, INTENT(IN) :: K_ARRAY(*)
    INTEGER, INTENT(IN) :: LDA_ARRAY(*)
    INTEGER, INTENT(IN) :: LDB_ARRAY(*)
    INTEGER, INTENT(IN) :: LDC_ARRAY(*)
    INTEGER, INTENT(IN) :: GROUP_COUNT
    INTEGER, INTENT(IN) :: GROUP_SIZE(*)
  END SUBROUTINE DGEMM_BATCH
  PURE SUBROUTINE CGEMM_BATCH(TRANSA_ARRAY,TRANSB_ARRAY,M_ARRAY,N_ARRAY,&
     &                        K_ARRAY,ALPHA_ARRAY,A_ARRAY,LDA_ARRAY,    &
     &                        B_ARRAY,LDB_ARRAY,BETA_ARRAY,C_ARRAY,     &
     &                        LDC_ARRAY,GROUP_COUNT,GROUP_SIZE)
    use, intrinsic :: ISO_C_BINDING
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: A_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: B_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(INOUT) :: C_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB_ARRAY(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA_ARRAY(*)
    COMPLEX(WP), INTENT(IN) :: BETA_ARRAY(*)
    INTEGER, INTENT(IN) :: M_ARRAY(*)
    INTEGER, INTENT(IN) :: N_ARRAY(*)
    INTEGER, INTENT(IN) :: K_ARRAY(*)
    INTEGER, INTENT(IN) :: LDA_ARRAY(*)
    INTEGER, INTENT(IN) :: LDB_ARRAY(*)
    INTEGER, INTENT(IN) :: LDC_ARRAY(*)
    INTEGER, INTENT(IN) :: GROUP_COUNT
    INTEGER, INTENT(IN) :: GROUP_SIZE(*)
  END SUBROUTINE CGEMM_BATCH
  PURE SUBROUTINE ZGEMM_BATCH(TRANSA_ARRAY,TRANSB_ARRAY,M_ARRAY,N_ARRAY,&
     &                        K_ARRAY,ALPHA_ARRAY,A_ARRAY,LDA_ARRAY,    &
     &                        B_ARRAY,LDB_ARRAY,BETA_ARRAY,C_ARRAY,     &
     &                        LDC_ARRAY,GROUP_COUNT,GROUP_SIZE)
    use, intrinsic :: ISO_C_BINDING
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: A_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: B_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(INOUT) :: C_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB_ARRAY(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA_ARRAY(*)
    COMPLEX(WP), INTENT(IN) :: BETA_ARRAY(*)
    INTEGER, INTENT(IN) :: M_ARRAY(*)
    INTEGER, INTENT(IN) :: N_ARRAY(*)
    INTEGER, INTENT(IN) :: K_ARRAY(*)
    INTEGER, INTENT(IN) :: LDA_ARRAY(*)
    INTEGER, INTENT(IN) :: LDB_ARRAY(*)
    INTEGER, INTENT(IN) :: LDC_ARRAY(*)
    INTEGER, INTENT(IN) :: GROUP_COUNT
    INTEGER, INTENT(IN) :: GROUP_SIZE(*)
  END SUBROUTINE ZGEMM_BATCH
END INTERFACE F77_GEMM_BATCH

INTERFACE F77_GEMM3M_BATCH
  PURE SUBROUTINE CGEMM3M_BATCH(TRANSA_ARRAY,TRANSB_ARRAY,M_ARRAY,      &
     &                          N_ARRAY,K_ARRAY,ALPHA_ARRAY,A_ARRAY,    &
     &                          LDA_ARRAY,B_ARRAY,LDB_ARRAY,BETA_ARRAY, &
     &                          C_ARRAY,LDC_ARRAY,GROUP_COUNT,GROUP_SIZE)
    use, intrinsic :: ISO_C_BINDING
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: A_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: B_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(INOUT) :: C_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB_ARRAY(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA_ARRAY(*)
    COMPLEX(WP), INTENT(IN) :: BETA_ARRAY(*)
    INTEGER, INTENT(IN) :: M_ARRAY(*)
    INTEGER, INTENT(IN) :: N_ARRAY(*)
    INTEGER, INTENT(IN) :: K_ARRAY(*)
    INTEGER, INTENT(IN) :: LDA_ARRAY(*)
    INTEGER, INTENT(IN) :: LDB_ARRAY(*)
    INTEGER, INTENT(IN) :: LDC_ARRAY(*)
    INTEGER, INTENT(IN) :: GROUP_COUNT
    INTEGER, INTENT(IN) :: GROUP_SIZE(*)
  END SUBROUTINE CGEMM3M_BATCH
  PURE SUBROUTINE ZGEMM3M_BATCH(TRANSA_ARRAY,TRANSB_ARRAY,M_ARRAY,      &
     &                          N_ARRAY,K_ARRAY,ALPHA_ARRAY,A_ARRAY,    &
     &                          LDA_ARRAY,B_ARRAY,LDB_ARRAY,BETA_ARRAY, &
     &                          C_ARRAY,LDC_ARRAY,GROUP_COUNT,GROUP_SIZE)
    use, intrinsic :: ISO_C_BINDING
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: A_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: B_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(INOUT) :: C_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSB_ARRAY(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA_ARRAY(*)
    COMPLEX(WP), INTENT(IN) :: BETA_ARRAY(*)
    INTEGER, INTENT(IN) :: M_ARRAY(*)
    INTEGER, INTENT(IN) :: N_ARRAY(*)
    INTEGER, INTENT(IN) :: K_ARRAY(*)
    INTEGER, INTENT(IN) :: LDA_ARRAY(*)
    INTEGER, INTENT(IN) :: LDB_ARRAY(*)
    INTEGER, INTENT(IN) :: LDC_ARRAY(*)
    INTEGER, INTENT(IN) :: GROUP_COUNT
    INTEGER, INTENT(IN) :: GROUP_SIZE(*)
  END SUBROUTINE ZGEMM3M_BATCH
END INTERFACE F77_GEMM3M_BATCH

INTERFACE F77_TRSM_BATCH
  PURE SUBROUTINE STRSM_BATCH(SIDE_ARRAY,UPLO_ARRAY,TRANSA_ARRAY,DIAG_ARRAY,&
     &                        M_ARRAY,N_ARRAY,ALPHA_ARRAY,A_ARRAY,LDA_ARRAY,&
     &                        B_ARRAY,LDB_ARRAY,GROUP_COUNT,GROUP_SIZE)
    use, intrinsic :: ISO_C_BINDING
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: A_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: B_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: DIAG_ARRAY(*)
    REAL(WP), INTENT(IN) :: ALPHA_ARRAY(*)
    INTEGER, INTENT(IN) :: M_ARRAY(*)
    INTEGER, INTENT(IN) :: N_ARRAY(*)
    INTEGER, INTENT(IN) :: LDA_ARRAY(*)
    INTEGER, INTENT(IN) :: LDB_ARRAY(*)
    INTEGER, INTENT(IN) :: GROUP_COUNT
    INTEGER, INTENT(IN) :: GROUP_SIZE(*)
  END SUBROUTINE STRSM_BATCH
  PURE SUBROUTINE DTRSM_BATCH(SIDE_ARRAY,UPLO_ARRAY,TRANSA_ARRAY,DIAG_ARRAY,&
     &                        M_ARRAY,N_ARRAY,ALPHA_ARRAY,A_ARRAY,LDA_ARRAY,&
     &                        B_ARRAY,LDB_ARRAY,GROUP_COUNT,GROUP_SIZE)
    use, intrinsic :: ISO_C_BINDING
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: A_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: B_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: DIAG_ARRAY(*)
    REAL(WP), INTENT(IN) :: ALPHA_ARRAY(*)
    INTEGER, INTENT(IN) :: M_ARRAY(*)
    INTEGER, INTENT(IN) :: N_ARRAY(*)
    INTEGER, INTENT(IN) :: LDA_ARRAY(*)
    INTEGER, INTENT(IN) :: LDB_ARRAY(*)
    INTEGER, INTENT(IN) :: GROUP_COUNT
    INTEGER, INTENT(IN) :: GROUP_SIZE(*)
  END SUBROUTINE DTRSM_BATCH
  PURE SUBROUTINE CTRSM_BATCH(SIDE_ARRAY,UPLO_ARRAY,TRANSA_ARRAY,DIAG_ARRAY,&
     &                        M_ARRAY,N_ARRAY,ALPHA_ARRAY,A_ARRAY,LDA_ARRAY,&
     &                        B_ARRAY,LDB_ARRAY,GROUP_COUNT,GROUP_SIZE)
    use, intrinsic :: ISO_C_BINDING
    INTEGER, PARAMETER :: WP = KIND(1.0E0)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: A_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: B_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: DIAG_ARRAY(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA_ARRAY(*)
    INTEGER, INTENT(IN) :: M_ARRAY(*)
    INTEGER, INTENT(IN) :: N_ARRAY(*)
    INTEGER, INTENT(IN) :: LDA_ARRAY(*)
    INTEGER, INTENT(IN) :: LDB_ARRAY(*)
    INTEGER, INTENT(IN) :: GROUP_COUNT
    INTEGER, INTENT(IN) :: GROUP_SIZE(*)
  END SUBROUTINE CTRSM_BATCH
  PURE SUBROUTINE ZTRSM_BATCH(SIDE_ARRAY,UPLO_ARRAY,TRANSA_ARRAY,DIAG_ARRAY,&
     &                        M_ARRAY,N_ARRAY,ALPHA_ARRAY,A_ARRAY,LDA_ARRAY,&
     &                        B_ARRAY,LDB_ARRAY,GROUP_COUNT,GROUP_SIZE)
    use, intrinsic :: ISO_C_BINDING
    INTEGER, PARAMETER :: WP = KIND(1.0D0)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: A_ARRAY(*)
    INTEGER(KIND=C_SIZE_T), INTENT(IN) :: B_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: SIDE_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: UPLO_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: TRANSA_ARRAY(*)
    CHARACTER(LEN=1), INTENT(IN) :: DIAG_ARRAY(*)
    COMPLEX(WP), INTENT(IN) :: ALPHA_ARRAY(*)
    INTEGER, INTENT(IN) :: M_ARRAY(*)
    INTEGER, INTENT(IN) :: N_ARRAY(*)
    INTEGER, INTENT(IN) :: LDA_ARRAY(*)
    INTEGER, INTENT(IN) :: LDB_ARRAY(*)
    INTEGER, INTENT(IN) :: GROUP_COUNT
    INTEGER, INTENT(IN) :: GROUP_SIZE(*)
  END SUBROUTINE ZTRSM_BATCH
END INTERFACE F77_TRSM_BATCH

END MODULE F77_BLAS
