/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class DataChunk
extends Chunk {
    public DataChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(moduleBase, chunkHeader, dataInputStream);
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        WaveModule waveModule = (WaveModule)this._module;
        Property property = new Property("DataLength", PropertyType.LONG, new Long(this.bytesLeft));
        if (waveModule.getCompressionCode() == 1) {
            waveModule.addSamples(this.bytesLeft / (long)waveModule.getBlockAlign());
        }
        waveModule.addWaveProperty(new Property("Data", PropertyType.PROPERTY, property));
        waveModule.markFirstSampleOffset();
        waveModule.skipBytes(this._dstream, (int)this.bytesLeft, waveModule);
        return true;
    }
}

