/****************************************************************************
 **
 ** $Id: cvstoolbar.cpp,v 1.57 2004/12/20 20:31:02 tilo Exp $
 **
 ** Copyright (C) 2001-2004 The LinCVS development team.
 **    Tilo Riemer <riemer@lincvs.org>
 **    Falk Brettschneider <gigafalk@yahoo.com>
 **    Frank Hemer <frank@hemer.org>
 **    Wim Delvaux <wim.delvaux@chello.be>
 **    Jose Hernandez <joseh@tesco.net>
 **    Helmut Koll <HelmutKoll@web.de>
 **    Tom Mishima <tmishima@mail.at-m.or.jp>
 **    Joerg Preiss <auba@auba.de>
 **    Sven Trogisch <trogisch@iapp.de>
 **
 **
 **----------------------------------------------------------------------------
 **
 **----------------------------------------------------------------------------
 **
 ** LinCVS is available under two different licenses:
 **
 ** If LinCVS is linked against the GPLed version of Qt 
 ** LinCVS is released under the terms of GPL also.
 **
 ** If LinCVS is linked against a nonGPLed version of Qt 
 ** LinCVS is released under the terms of the 
 ** LinCVS License for non-Unix platforms (LLNU)
 **
 **
 ** LinCVS License for non-Unix platforms (LLNU):
 **
 ** Redistribution and use in binary form, without modification, 
 ** are permitted provided that the following conditions are met:
 **
 ** 1. Redistributions in binary form must reproduce the above copyright
 **    notice, this list of conditions and the following disclaimer in the
 **    documentation and/or other materials provided with the distribution.
 ** 2. It is not permitted to distribute the binary package under a name
 **    different than LinCVS.
 ** 3. The name of the authors may not be used to endorse or promote
 **    products derived from this software without specific prior written
 **    permission.
 ** 4. The source code is the creative property of the authors.
 **    Extensions and development under the terms of the Gnu Public License
 **    are limited to the Unix platform. Any distribution or compilation of 
 **    the source code against libraries licensed other than gpl requires 
 **    the written permission of the authors.
 **
 **
 ** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
 ** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 ** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 ** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
 ** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 ** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
 ** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
 ** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 ** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 ** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 ** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 **
 **
 **
 ** LinCVS License for Unix platforms:
 **
 ** This program is free software; you can redistribute it and/or modify 
 ** it under the terms of the GNU General Public License as published by 
 ** the Free Software Foundation; either version 2 of the License, or 
 ** (at your  option) any later version.  This program is distributed in 
 ** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
 ** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 ** PARTICULAR PURPOSE.
 **
 ** See the GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software Foundation,
 ** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 **
 *****************************************************************************/


#include "config.h"

#include <qaction.h>
#include <qwhatsthis.h>     
#include <qiconset.h>
#include <qwidget.h>
#include <qstring.h>
#include <qapplication.h>
#include <qlayout.h>
#include <qtoolbar.h>

#include "globals.h"
#include "cvstoolbar.h"

// pixmaps 
#include "pixmapcache.h"

// -- internal objects ---------------------------------------------------

static const QString whatsThisTextInt[]= {
  
   /* add2Wb */
   QObject::tr("Click this button to add a <em>new folder</em> to the workbench.<br>" 
	 "You can also select <br> <b>Project -> Add to Workbench</b><br> from the menu."),
  
   /* stopAction */
   QObject::tr("When highlighted button is clicked any current action is terminated immediately."
	 "When disabled nothing happens."),

   /* exit */
   QObject::tr("Exit LinCVS."),

   /* info */
   QObject::tr("Click this button to get some information about this program "
	 "like the authors and GNU GPL.<br>"
	 "You can also select <b>Help -> About</b> from the menu."),

   /* import */
   QObject::tr("Click this button to <em>import</em> a new project or folder "
	 "into the CVS repository. It's <b>not</b> a <em>cvs check in </em>, but puts a new "
	 "project under cvs control.<br>"
	 "You can also select <br><b>Project -> Import</b><br>from the menu."),
   
   /* co */
   QObject::tr("Click this button to <em>ckeck out</em> a project from the CVS repository "
	 "into your workbench.<br> You can also select <br><b>Project -> Checkout</b><br>"
	 "from the menu."),
 
   /* upd */
   QObject::tr("Click this button to update the status of your modules.<br>"
	 "Normally this is done automatically due to the timer settings and you should never "
	 "use it.<br> But for those users who have bad time resources and put therefore a "
	 "long time constant this is a possibility to do this manually before they do any "
	 "action with cvs.<br> You can also select the <br><b>Options->Status Update->Immediate</b> <br>"
	 "from the menu."),

   /* autoupd */
   QObject::tr("Push this button to enable auto update mechanism.<br>"
	 "All Projects with enabled autoupdate property will run a cvs update command every time the autoupdate "
	 "intervall specified in the Settings has expired.<br>"
	 "The autoupdate property can be set with Directory/Properties."),

   /* cvsupd */
   QObject::tr("In case you marked a folder or a file then clicking this button runs a cvs update "
	 "on it. You can also select this function from the menu or the context menu"),

   /* cvscom */
   QObject::tr("In case you marked a folder or a file then clicking this button runs a cvs commit "
	 "on it. You can also select this function from the menu or the context menu"),

   /* cvs merge */
   QObject::tr("In case you marked a folder or a file then clicking this button opens a dialog where you can "
	 "specify which versions to merge. If Ok is clicked, runs a cvs merge.<br>"
	 "You can also select this function from the menu or the context menu, or merge from within the log dialog.")

};

// -- external objects ---------------------------------------------------

static const QString whatsThisText[]= {
  
   /* wbench */
   QObject::tr("This is your working area<br>"
	 "In this area all the folders are listed that you have already checked out with LinCVS. "
	 "Additionally all folders you have added with the command <br>"
	 "<b>Project-Explorer -> Add to Workbench</b><br>are listed here.<br>"),

   /* cvsFile */  
   QObject::tr("When clicked on a folder in the workbench in this area all <em>checked out</em> " 
	 "files are listed together with some status information described in the headline."
	 "This information is updated periodically due to the timer settings. LinCVS keeps track "
	 "with changes even if they are caused from outside LinCVS, ie. by a cvs commandline call."
	 "When you click on a file with your right mouse button a context menu is opened."),

   /* nonCvsFile */
   QObject::tr("In this area all the files are listed which are currently not under cvs control. "
	 "To put a file under cvs control (add a file to the repository) just click it with your "
	 "right mouse button, choose add and do a commit afterwards."),

   /* cvs ignore */
   QObject::tr("In this area all the files are listed that cvs will ignore when operating on a dir. "
	 "The contents depends on the settings in ~/.cvsignore, the CVSIGNORE environment variable and the .cvsignore files in "
	 "all the directories under cvs control in this order. The files to ignore are selected via wildcards, "
	 "an ! (exclamation mark) will reset all previous settings."),

   /* tabFileList */
   QObject::tr("When you select a folder in the workbench then the whole directory contents of a "
	 "CVS project is listed in these three tabs. Splitted into <em>CVS</em> and <em>NON CVS</em> and <em>CVS IGNORE</em> files."),
  
   /* status */
   QObject::tr("Here you find the cvs generated output from cvs calls like status, diff, log .. etc. This output is just for your convenience, "
	 "LinCVS will handle the file states and so on in its own user dialoges."),
};


 
/*---------------------------------------------------------------------------*
 *  Prototypes / classes                                                     *
 *---------------------------------------------------------------------------*/

cvsToolbar::cvsToolbar (QMainWindow *parent) : QToolBar(parent)
{
   // create buttons for toolbar    
   QIconSet is_exit(findEmbeddedPixmap("quit_16x16"));
   is_exit.setPixmap(findEmbeddedPixmap("quit_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_exit = new QToolButton(is_exit,
	 tr("Exit application"), QString::null,
	 qApp, SLOT(closeAllWindows()), this, "Exit");

   this->addSeparator();

   QIconSet is_stop(findEmbeddedPixmap("stop_16x16"));
   is_stop.setPixmap(findEmbeddedPixmap("stop_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   m_pStopAction = new QToolButton(is_stop,
	 tr("Stop Action"), QString::null, parent, 
	 SLOT(stopCurAction()), this, "stop action");  

   m_pStopAction->setEnabled(false);

   this->addSeparator();

   QIconSet is_cvsUpd(findEmbeddedPixmap("update_16x16"));
   is_cvsUpd.setPixmap(findEmbeddedPixmap("update_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_cvsUpd = new QToolButton (is_cvsUpd,
	 tr("cvs update"), QString::null, parent,
	 SLOT(slot_updateAny()), this, "Update");

   QIconSet is_commit(findEmbeddedPixmap("commit_16x16"));
   is_commit.setPixmap(findEmbeddedPixmap("commit_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_com = new QToolButton (is_commit,
	 tr("cvs commit"), QString::null, parent, 
	 SLOT(slot_commitAny()), this, "Commit");

   QIconSet is_cvsMerge(findEmbeddedPixmap("merge_16x16"));
   is_cvsMerge.setPixmap(findEmbeddedPixmap("merge_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_cvsMerge = new QToolButton (is_cvsMerge,
	 tr("cvs merge"), QString::null, parent,
	 SLOT(slot_mergeAny()), this, "Merge");

   QIconSet is_co(findEmbeddedPixmap("checkout_16x16"));
   is_co.setPixmap(findEmbeddedPixmap("checkout_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_co = new QToolButton (is_co,
	 tr("cvs check out"), QString::null, parent,
	 SLOT(slot_checkoutProject()), this, "check out");

   QIconSet is_imp(findEmbeddedPixmap("CmdImport32x32"));
   is_imp.setPixmap(findEmbeddedPixmap("CmdImport_disabled_32x32"), QIconSet::Automatic, QIconSet::Disabled);
   tb_imp = new QToolButton (is_imp,
	 tr("cvs import"), QString::null, parent,
	 SLOT(slot_importProject()), this, "import");

   this->addSeparator();

   QIconSet is_addWb(findEmbeddedPixmap("module_add_16x16"));
   is_addWb.setPixmap(findEmbeddedPixmap("module_add_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_addWb = new QToolButton (is_addWb,
	 tr("add to workbench"), QString::null, parent, 
	 SLOT(slot_addProject()), this, "open file");

   QIconSet is_upd(findEmbeddedPixmap("module_status_16x16"));
   is_upd.setPixmap(findEmbeddedPixmap("module_status_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_upd = new QToolButton (is_upd,
	 tr("update module status"), QString::null, parent, 
	 SLOT(slot_checkStatus()), this, "update");
     
   QIconSet is_autoupd(findEmbeddedPixmap("module_autoupdate_16x16"));
   is_autoupd.setPixmap(findEmbeddedPixmap("module_autoupdate_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_autoupd = new QToolButton (is_autoupd,
	 tr("autoupdate"), QString::null, this,
	 SLOT(toggle_autoupdate()), this, "autoupdate");
   tb_autoupd->setToggleButton(TRUE);

   this->addSeparator();   

   QIconSet is_annotate(findEmbeddedPixmap("cvs_annotate_16x16"));
   is_annotate.setPixmap(findEmbeddedPixmap("cvs_annotate_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_annotate = new QToolButton (is_annotate,
	 tr("cvs annotate"), QString::null, parent, 
	 SLOT(slot_annotateAny()), this, "annotate");
   QIconSet is_annotateGrepLine(findEmbeddedPixmap("who_changed_line_16x16"));
   is_annotateGrepLine.setPixmap(findEmbeddedPixmap("who_changed_line_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_annotateGrepLine = new QToolButton (is_annotateGrepLine,
	 tr("Who has changed which line?"), QString::null, parent, 
	 SLOT(slot_annotateGrepLineAny()), this, "annotate_grep_line");
   QIconSet is_annotateGrepLines(findEmbeddedPixmap("who_changed_lines_16x16"));
   is_annotateGrepLines.setPixmap(findEmbeddedPixmap("who_changed_lines_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_annotateGrepLines = new QToolButton (is_annotateGrepLines,
	 tr("Who has changed which lines?"), QString::null, parent, 
	 SLOT(slot_annotateGrepLinesAny()), this, "annotate_grep_lines");

   this->addSeparator();   

   QIconSet is_watchAdd(findEmbeddedPixmap("cvs_watch_add_16x16"));
   is_watchAdd.setPixmap(findEmbeddedPixmap("cvs_watch_add_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_watchAdd = new QToolButton (is_watchAdd,
	 tr("cvs watch add"), QString::null, parent, 
	 SLOT(slot_watchAddAny()), this, "watch add");
   QIconSet is_watchRemove(findEmbeddedPixmap("cvs_watch_remove_16x16"));
   is_watchRemove.setPixmap(findEmbeddedPixmap("cvs_watch_remove_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_watchRemove = new QToolButton (is_watchRemove,
	 tr("cvs watch remove"), QString::null, parent, 
	 SLOT(slot_watchRemoveAny()), this, "watch remove");
   QIconSet is_watchOn(findEmbeddedPixmap("cvs_watch_on_16x16"));
   is_watchOn.setPixmap(findEmbeddedPixmap("cvs_watch_on_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_watchOn = new QToolButton (is_watchOn,
	 tr("cvs watch on"), QString::null, parent, 
	 SLOT(slot_watchOnAny()), this, "watch on");
   QIconSet is_watchOff(findEmbeddedPixmap("cvs_watch_off_16x16"));
   is_watchOff.setPixmap(findEmbeddedPixmap("cvs_watch_off_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_watchOff = new QToolButton (is_watchOff,
	 tr("cvs watch off"), QString::null, parent, 
	 SLOT(slot_watchOffAny()), this, "watch off");

   this->addSeparator();   

   QIconSet is_info(findEmbeddedPixmap("lincvs-16"));
   is_info.setPixmap(findEmbeddedPixmap("lincvs_disabled_16x16"), QIconSet::Automatic, QIconSet::Disabled);
   tb_info = new QToolButton (is_info,
	 tr("info"), QString::null, parent, 
	 SLOT(slot_about()), this, "info");

   QToolButton* pWhatsThis = QWhatsThis::whatsThisButton (this);
   m_whatsThisIconSet = pWhatsThis->iconSet();        
        
   /* Make the toolbar stretch the width or height of the
    * main window depending on orientation.
    */
   setHorizontalStretchable(true);
   setVerticalStretchable(true);

   this->addWhatsThisTextInt (tb_addWb, add2Wb);
   this->addWhatsThisTextInt (m_pStopAction, stopAction);
   this->addWhatsThisTextInt (tb_exit, exit );
   this->addWhatsThisTextInt (tb_info, info);
   this->addWhatsThisTextInt (tb_imp, import);
   this->addWhatsThisTextInt (tb_co, co);
   this->addWhatsThisTextInt (tb_upd, upd);
   this->addWhatsThisTextInt (tb_autoupd, autoupd);
   this->addWhatsThisTextInt (tb_cvsUpd, cvsupd);
   this->addWhatsThisTextInt (tb_com, cvscom);
   this->addWhatsThisTextInt (tb_cvsMerge, cvsmerge);

   //set config state
   autoUpdateChanged();
}

void cvsToolbar::autoUpdateChanged() {
   tb_autoupd->setOn(AUTOUPDATE);
}

void cvsToolbar::toggle_autoupdate() {

   if (tb_autoupd->isOn() != AUTOUPDATE) {
      AUTOUPDATE = tb_autoupd->isOn();
      emit autoUpdateStateChanged();
   }

}


/*---------------------------------------------------------------------------*/
/*!
  \fn			cvsToolbar::~cvsToolbar(void)
  \brief		dtor.

  <BR><HR>*/
/*---------------------------------------------------------------------------*/

cvsToolbar::~cvsToolbar(void) { }



/*---------------------------------------------------------------------------*/
/*!
  \fn			void cvsToolbar::addWhatsThisTextInt(QToolButton *tb, T_wtTextInt textType )
  \brief		For internal toolbuttons

  \param		*tb		toolbutton
  \param		textType		index of QString whatsThisTextInt[]

  <BR><HR>*/
/*---------------------------------------------------------------------------*/

void cvsToolbar::addWhatsThisTextInt(QToolButton *tb, T_wtTextInt textType )
{
   QWhatsThis::add( (QWidget*)tb, tr(whatsThisTextInt[textType]) );
}


/*---------------------------------------------------------------------------*/
/*!
  \fn			void cvsToolbar::addWhatsThisText( void *ptr,  T_wtText textType  )
  \brief		for external objects

  \param		*ptr		poiter to object
  \param		textType		index of QString whatsThisText[]

  <BR><HR>*/
/*---------------------------------------------------------------------------*/

void cvsToolbar::addWhatsThisText( void *ptr,  T_wtText textType  )
{
   QWhatsThis::add( (QWidget*)ptr, tr(whatsThisText[textType]) );  
}


//   Enable or disable all Buttons except stop

void cvsToolbar::setEnabled( bool state) {
   tb_exit->setEnabled(state);
   tb_cvsMerge->setEnabled(state);
   tb_cvsUpd->setEnabled(state);
   tb_com->setEnabled(state);
   tb_co->setEnabled(state);
   tb_imp->setEnabled(state);
   tb_addWb->setEnabled(state);
   tb_upd->setEnabled(state);
   tb_autoupd->setEnabled(state);
   tb_annotate->setEnabled(state);
   tb_annotateGrepLine->setEnabled(state);
   tb_annotateGrepLines->setEnabled(state);
   tb_watchAdd->setEnabled(state);
   tb_watchRemove->setEnabled(state);
   tb_watchOn->setEnabled(state);
   tb_watchOff->setEnabled(state);
   tb_info->setEnabled(state);
}
/*--------- END OF FILE -----------------------------------------------------*/
