/*
**  HEADER FILE FOR NEWS/MAIL GATEWAY CODE.
**  $Header: /nfs/papaya/u2/rsalz/src/newsgate/RCS/gate.h,v 1.19 91/07/18 21:14:18 rsalz Exp Locker: rsalz $
*/
/* SUPPRESS 460 *//* '/' '*' occurred inside a comment */


/*
**  START OF CONFIGURATION SECTION
*/


/* Paths to some parts of your netnews installation.  Required.
 * If you set INEWS to point to a C News relaynews, then set NO_H_FLAG. */
#define INEWS		"/usr/lib/news/inews"
#define ACTIVE		"/usr/lib/news/active"
#define NGDELIM		','

/* If you #define this, then the -h flag will not be appended and the -=
 * flag will not delete it. */
#undef NO_H_FLAG

/* In writing Paths into From addresses, we can look at the output
 * of uuname from the L.sys file.  Define both or neither of the next
 * two.  We can also map some UUCP names to their domain names, if
 * the third line is enabled.  The UUCP_INET should match the value
 * in the Makefile.  This violates the "write once" rule, but it's
 * too much of a pain to fix for this one symbol. */
#define UUNAME		"/usr/lib/news/.admin/uuname.out"
#define L_SYS		"/usr/lib/uucp/L.sys"
#define UUCP_INET	"/usr/lib/news/.admin/uucp-2-inet"


/* Do you want news2mail to use the Path line in generating the From line?
 */
#define USE_PATH_FOR_FROM


/* Do you need to handle eight-bit characters in your addresses?  If
 * not (e.g., just USASCII) then #undef the next line.
 */
#define DO_8BIT_CHARS


/* Where does the control file for talk.foo live?
 *	IN_ONEPLACE:	specified filename
 *	IN_SPOOLDIR:	/usr/spool/news/talk/foo/recnews.cmd
 *	IN_CMDDIR:	/usr/lib/news/.admin/talk.foo
 * One of these is required, but you can set IN_ONEPLACE to /dev/null to
 * disable the newsgroup editing. */
#undef IN_ONEPLACE	"/dev/null"
#undef IN_SPOOLDIR	"/usr/spool/news"
#define	IN_CMDDIR	"/usr/lib/news/.admin"


/* What do you want to do with the Path: line?  Put in a fixed string
 * (such as pointing to a mail reflector saying "Don't trust Path
 * lines as a way to reply").  Put a fixed "fake host" in the Path
 * before the user's host and name, or put just the user's host and
 * name there.  Note that the latter two can cause the poster's site
 * to never get the article sent to them.  Anyhow, pick one.  To pick
 * neither #define is to get the third behavior -- the user's host. */
#define FIXED_PATH	"gateway"		/* .. */
#undef	GATEWAY_NAME	"gateway"

/* If the "hostname" you use for news (such as in the pathline) is not
 * the same as `hostname`, then define WHOAMI to be your news name (e.g.,
 * the contents of the C News file /usr/lib/news/whoami). */
#undef WHOAMI		"bbn"


/* The code in hdr.c does lots of work to canonicalize addresses.  You
 * might want to disable it if your sendmail.cf (e.g.) is very very good.
 * You might want to disable DO_GETHOSTBYNAME because gethostbyname(3)
 * doesn't handle MX records, and in some setups doesn't return a full
 * domain name. */
#define DO_ADDRESS_CLEANUP			/* .. */
#define DO_GETHOSTBYNAME			/* .. */


/* Are you running sendmail or MMDF?  Pick one.  If you believe in
 * trusted users (MMDF doesn't?) to lie to your mailer, set the
 * user-ID. */
#undef SENDMAIL	"/usr/lib/sendmail"
#undef TRUSTED		1
#define	MMDF		"/usr/mmdf/lib/submit"	/* .. */
#undef MMDF_DELIVER_NOW


/* Does your Sendmail mailer have the M flag on, requiring a Message-ID?
 * And do you want to require that the first line by a "From " line? */
#if	defined(SENDMAIL)
#define REQUIRE_MESSAGE_ID			/* .. */
#undef REQUIRE_UNIX_FROM
#endif	/* defined(SENDMAIL) */


/* I love how we all speak the same language. */
#define CATCHER		void		/* Type of a signal-catcher	*/
#define IDX		index
#define RDX		rindex
typedef int		*align_t;	/* Worst-case alignment, for lint */
#define CHARSTAR_SPRINTF		/* Need extern char *sprintf();	*/
#define VOID_EXIT			/* Need extern void exit();	*/
#define HAVE_SYSEXITS			/* Have <sysexits.h>?		*/
#define HAVE_PUTENV			/* Have putenv(3)		*/
#undef HAVE_STRERROR			/* Have strerror(3)?		*/

#define SM_SIZE		512		/* A smallish buffer size	*/
#define LG_SIZE		1024		/* big buffer size		*/

/* Error log (stderr) for news2mail. */
#define ERR_LOG		"/usr/lib/news/.admin/news2mail.out"
#define TEMPFILE	"/tmp/gateXXXXXX" /* Temporary file pattern	*/


/* Enable debugging code? */
#define STATIC		static
#if	!defined(lint) && !defined(SABER)
#define RCSID
#endif	/* !defined(lint) && !defined(SABER) */

/*
**  END OF CONFIGURATION SECTION.
*/



#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>

#if	defined(HAVE_SYSEXITS)
#include <sysexits.h>
#else
#include "sysexits.h"
#endif	/* defined(HAVE_SYSEXITS) */


typedef struct _HBUF {
    char	approved[SM_SIZE];	/* Approved:		*/
    char	ctlmsg[LG_SIZE];	/* Control:		*/
    char	subdate[SM_SIZE];	/* Date: (submission)	*/
    char	distribution[SM_SIZE];	/* Distribution:	*/
    char	expdate[SM_SIZE];	/* Expires:		*/
    char	followto[SM_SIZE];	/* Followup-to:		*/
    char	from[SM_SIZE];		/* From:		*/
    char	followid[SM_SIZE];	/* References:		*/
    char	keywords[SM_SIZE];	/* Keywords:		*/
    char	ident[SM_SIZE];		/* Message-ID:		*/
    char	nbuf[LG_SIZE];		/* Newsgroups:		*/
    char	organization[SM_SIZE];	/* Organization:	*/
    char	title[SM_SIZE];		/* Subject:		*/
    char	replyto[SM_SIZE];	/* Reply-To:		*/
    char	summary[SM_SIZE];	/* Summary:		*/
    char	path[LG_SIZE];		/* Path:		*/
    char	sender[SM_SIZE];	/* Sender:		*/
    char	mimeversion[SM_SIZE];	/* MIME-Version:	*/
    char	mimexfer[LG_SIZE];	/* Content-Transfer-Encoding: */
    char	mimetype[LG_SIZE];	/* Content-Type:	*/
} HBUF;

#if	defined(__GNUC__) || defined(__STDC__)
typedef char const	*STRING;
#else
typedef char		*STRING;
#endif	/* defined(__GNUC__) || defined(__STDC__) */

/* String and memory manipulators. */
#define APPEND(p, t)	strlen(strcpy((p), (t)))
#define NEW(T, c)	(T *)MyAlloc((int)((c) * sizeof (T)))
#define COPY(s)		strcpy(NEW(char, strlen((s)) + 1), (s))
#define REALLOC(p, s)	realloc((char *)(p), (unsigned int)(s))


/* Array sizing. */
#define SIZEOF(x)	(sizeof x / sizeof x[0])
#define ENDOF(x)	(&x[SIZEOF(x)])

#if	!defined(DO_8BIT_CHARS)
#define ADDRCHAR	char	/* Addresses internal representation	*/
#define QUOTE_MASK	0x0080	/* Mask to turn on 8-bit quoting	*/
#define UNQUOTE_MASK	0x007F	/* Mask to turn off the 8-bit quote	*/
#else
#define ADDRCHAR	short	/* Addresses internal representation	*/
#define QUOTE_MASK	0x0100	 /* Mask to turn on 9-bit quoting	*/
#define UNQUOTE_MASK	0x00FF	/* Mask to turn off the 9-bit quote	*/
#endif	/* !defined(DO_8BIT_CHARS) */

/* String and character operations. */
#define WHITE(c)	((c) == ' ' || (c) == '\t')
#define EQ(a, b)	((a)[0] == (b)[0] && strcmp((a), (b)) == 0)
#define EQn(a, b, n)	((a)[0] == (b)[0] && strncmp((a), (b), (n)) == 0)
#define NETCHR(c)	((c) == '%' || (c) == '@' || (c) == '!')
#define CHREQ(c, d)	((d) == (islower((c)) ? toupper((c)) : (c)))


/* Fundamental constants of the universe. */
#define TRUE		1
#define FALSE		0
#define FAIL		(-1)


/* SHUT UP! */
#if	defined(lint)
#undef	putc
#undef	putchar
#endif	/* defined(lint) */

#define Close		(void)close
#define Fflush		(void)fflush
#define Fprintf		(void)fprintf
#define Fputs		(void)fputs
#define Signal		(void)signal
#define Sprintf		(void)sprintf
#define Strcpy		(void)strcpy
#define Strcat		(void)strcat
#define Strncpy		(void)strncpy


/*
**  External declarations.
*/

/* Program name; exists once for each main(). */
extern	char	*Pname;

/* Routines we provide. */
extern align_t	MyAlloc();
extern int	Split();
extern int	CrackFrom();
extern void	re_modw();
extern void	SplitFree();
extern void	FreeFile();
extern char	**ReadFile();
extern char	*re_comp();
extern STRING	HackHeader();
extern void	rfc822read();
extern void	yyopen();
extern void	yyerror();
extern int	re_exec();
extern int	rfc822write();

extern char	*strerror();

/* Variables and routines that Unix(tm) provides. */
extern int	errno;
extern int	sys_nerr;
extern int	optind;
extern char	*sys_errlist[];
extern char	**environ;
extern char	*optarg;

extern FILE	*popen();
extern char	*IDX();
extern char	*RDX();
extern char	*ctime();
extern char	*malloc();
extern char	*mktemp();
extern char	*realloc();
extern char	*strcat();
extern char	*strncat();
extern char	*strcpy();
extern char	*strncpy();
#if	defined(CHARSTAR_SPRINTF)
extern char	*sprintf();
#endif	/* defined(CHARSTAR_SPRINTF) */
#if	defined(VOID_EXIT)
extern void	exit();
#endif	/* defined(VOID_EXIT) */
