(*
// Eijiro Sumii (http://www.yl.is.s.u-tokyo.ac.jp/~sumii/)
// 
// Ph.D. Student at Department of IS, University of Tokyo
// Visiting Scholar at Department of CIS, University of Pennsylvania
*)

let strstr_fun2 pat str =
  let patlim = String.length pat - 1 in
  let strlim = String.length str - 1 in
  let rec sub patpos strpos =
    (* compare pat[0..patpos] and str[(strpos-patpos)..strpos] *)
    if patpos < 0 then true else
    if pat.[patpos] <> str.[strpos] then false else
    sub (patpos - 1) (strpos - 1) in
  let rec search strpos =
    (* compare pat[0..patlim] and str[(strpos-patlim)..strpos] *)
    if strpos > strlim then raise Not_found else
    if sub patlim strpos then strpos - patlim else
    search (strpos + 1) in
  search patlim
