(* File wc.ml *)

type counts = {
 mutable chars : int;
 mutable lines : int;
 mutable words : int;
};;

let wc_count = {chars = 0; lines = 0; words = 0};;
let wc_count_total = {chars = 0; lines = 0; words = 0};;

let reset_count () =
 wc_count.chars <- 0;
 wc_count.lines <- 0;
 wc_count.words <- 0;;

let cumulate () =
 wc_count_total.chars <- wc_count_total.chars + wc_count.chars;
 wc_count_total.lines <- wc_count_total.lines + wc_count.lines;
 wc_count_total.words <- wc_count_total.words + wc_count.words;;

let rec counter ic iw =
 let c = input_char ic in
 wc_count.chars <- wc_count.chars + 1;
 match c with
 | '\n' ->
    wc_count.lines <- wc_count.lines + 1;
    counter ic false
 | ' ' | '\t' ->
    counter ic false
 | _ ->
    if not iw then wc_count.words <- wc_count.words + 1 else ();
    counter ic true;;

let count_channel ic =
 reset_count ();
 try counter ic false with
 | End_of_file -> cumulate (); close_in ic;;

let output_results () =
  print_string "\tchars : "; print_int wc_count.chars;
  print_newline();
  print_string "\tlines : "; print_int wc_count.lines;
  print_newline();
  print_string "\twords : "; print_int wc_count.words;
  print_newline();;

let ouput_total () =
  print_string "Total:"; print_newline();
  print_string "\tchars : "; print_int wc_count_total.chars;
  print_newline();
  print_string "\tlines : "; print_int wc_count_total.lines;
  print_newline();
  print_string "\twords : "; print_int wc_count_total.words;
  print_newline();;

let count_file file_name =
 try
  let ic = open_in file_name in
  count_channel ic;
  print_string "File : "; print_string file_name; print_newline();
  output_results ()
 with Sys_error s -> print_string s; print_newline(); exit 2
;;

let main () =
 let args = Sys.argv in
 let nb_files = Array.length args - 1 in
 for i = 1 to nb_files do
  count_file args.(i)
 done;
 if nb_files > 1 then ouput_total ();
 exit 0;;

main();;
