open Sys;;

exception Erreur;;

let traite_fichier traitement nom_entre nom_sortie =
  let entre =
    try open_in_bin nom_entre
    with Sys_error message ->
      prerr_endline ("Erreur  l'ouverture de " ^ nom_entre
                     ^ " : " ^ message);
      raise Erreur in
  let sortie =
    try open_out_bin nom_sortie
    with Sys_error message ->
      close_in entre;
      prerr_endline ("Erreur  la cration de " ^ nom_sortie
                     ^ " : " ^ message);
      raise Erreur in
  try
    traitement entre sortie;
    close_in entre; close_out sortie; remove nom_entre
  with Sys_error message ->
    close_in entre; close_out sortie; remove nom_sortie;
    prerr_endline ("Erreur pendant le traitement de "
                   ^ nom_entre ^ " : " ^ message);
    raise Erreur;;

let compresse_fichier nom_fichier =
  traite_fichier Huffman.compresse
                 nom_fichier (nom_fichier ^ ".cpr");;

let dcompresse_fichier nom_fichier =
  let longueur = String.length nom_fichier in
  if longueur < 4
  || String.sub nom_fichier (longueur - 4) 4 <> ".cpr" then
    let nom_entre = nom_fichier ^ ".cpr"
    and nom_sortie = nom_fichier in
    traite_fichier Huffman.dcompresse nom_entre nom_sortie
  else
    let nom_entre = nom_fichier
    and nom_sortie = String.sub nom_fichier 0 (longueur - 4) in
    traite_fichier Huffman.dcompresse nom_entre nom_sortie;;

if !interactive then () else
  begin
    let erreur = ref false in
    if Array.length argv >= 2 && argv.(1) = "-d" then
      for i = 2 to Array.length argv - 1 do
        try dcompresse_fichier argv.(i)
        with Erreur -> erreur := true
      done
    else
      for i = 1 to Array.length argv - 1 do
        try compresse_fichier argv.(i)
        with Erreur -> erreur := true
      done;
    exit (if !erreur then 2 else 0)
  end;;
