open Graphics;;

open_graph "";;

remember_mode false;;
auto_synchronize true;;

type disque = {
  mutable x : int;
  mutable y : int;
  w : int;
  h : int;
  bg : image;
  fg : image;
};;

type tige = {
  mutable sommet : int;
  disques : disque option array;
  xt : int;
};;

let wood_color = black;;
let text_color = black;;

let tige_width = (size_x () / 5);;

let wood_width = 1 + 2 * 5;;

let half_tige_width = (tige_width - wood_width) / 2;;

let text_size_x s = let x, _ = text_size s in x;;
let text_size_y s = let _, y = text_size s in y;;

let tige_height, wood_height, base_tiges, vtab =
  let y = text_size_y "Graphics" in
  let vtab i = i * y in
  let tige_height = size_y () - 8 * y in
  tige_height, tige_height, vtab 5, vtab;;

let center i =
 let eps = size_x () / 10 in
 let h = half_tige_width in
 eps +  h + (i - 1) * (eps + 2 * h);;

(*let make_bg nombre_de_disques tige_width tige_heigth =
  let w = tige_width
  and h = tige_heigth / nombre_de_disques in
  let cur_bg = get_image 0 0 w h in
  set_color background;
  fill_rect x y w h;
  let bg = get_image 0 0 w h in
  draw_image cur_bg 0 0;
  bg;;*)

let tige_vide i nombre_de_disques =
  {sommet = 0;
   disques = Array.make nombre_de_disques None;
   xt = center i;
  };;

let make_color i =
  let colors = [| black; red; green; blue; yellow; cyan; magenta |] in
  colors.(i mod 7);;

let trace_wood x y =
 let x = x - ((wood_width - 1) / 2) in
 set_color wood_color;
 fill_rect x y wood_width tige_height;;

let make_disque tige nombre_de_disques i =
  let inc = half_tige_width / nombre_de_disques in
  let h =
   let h1 = tige_height / (nombre_de_disques + 1) in
   min h1 (3 * wood_width) in
  let r0 = h / 2 in
  let wr =
    let inc = half_tige_width / nombre_de_disques in
    let hwr = (nombre_de_disques - i) * inc in
    2 * hwr in
  let w = wr + 2 * r0 in
  let cur_bg = get_image 0 0 w (wood_height) in
  trace_wood (w / 2) 0;
  let bg = get_image 0 0 w h in
  let c = make_color i in
  set_color c;
  let x0 = r0 in
  fill_rect x0 0 wr h;
  fill_circle x0 r0 r0;
  fill_circle (x0 + wr) r0 r0;
  let fg = get_image 0 0 w h in
  let x = tige.xt - w / 2 in
  let y = base_tiges + i * h in
  let disque = { x = x; y = y; w = w; h = h; bg = bg; fg = fg} in
  draw_image cur_bg 0 0;
  disque;;

let tige_pleine i nombre_de_disques =
  let t = tige_vide i nombre_de_disques in
  for i = 0 to nombre_de_disques - 1 do
   t.disques.(i) <- Some (make_disque t nombre_de_disques i);
   t.sommet <- i
  done;
  t;;

let efface_disque tige =
  let bottom x = if x >= 0 then x else 0 in
  let s = tige.sommet in
  let disque =
   match tige.disques.(s) with
   | None -> assert false
   | Some d -> d in
  draw_image disque.bg disque.x disque.y;
  tige.disques.(s) <- None;
  tige.sommet <- bottom (s - 1);
  disque;;

let trace_disque tige disque =
  let s = tige.sommet in
  let x = tige.xt - (disque.w / 2) in
  let y =
    match tige.disques.(s) with
    | None -> base_tiges
    | Some d -> d.y + disque.h in
  disque.x <- x;
  disque.y <- y;
  draw_image disque.fg disque.x disque.y;
  tige.disques.(tige.sommet) <- Some disque;
  tige.sommet <- s + 1;;

let dplace (nom_dpart, dpart) (nom_destination, destination) =
  let disque = efface_disque dpart in
  trace_disque destination disque;;

let trace_tige t =
 trace_wood t.xt base_tiges;
 let disques = t.disques in
 for i = t.sommet downto 0 do
   match disques.(i) with
   | None -> ()
   | Some d -> draw_image d.fg d.x d.y;
 done;;

let center_text s x y =
 let trans = text_size_x s / 2 in
 moveto (x - trans) y;
 draw_string s;;

let imprime_jeu title
    (nom_gauche, gauche) (nom_milieu, milieu) (nom_droite, droite) =
  let baseline = vtab 1 in
  set_color text_color;
  center_text nom_gauche gauche.xt baseline;
  center_text nom_milieu milieu.xt baseline;
  center_text nom_droite droite.xt baseline;
  center_text title milieu.xt (vtab 3);
  trace_tige gauche;
  trace_tige milieu;
  trace_tige droite;;

let rec hanoi hauteur dpart intermdiaire destination =
    if hauteur > 0 then
     begin
       hanoi (hauteur - 1) dpart destination intermdiaire;
print_string "Just beginning"; print_newline();
       dplace dpart destination;
print_string "Almost finished"; print_newline();
       hanoi (hauteur - 1) intermdiaire dpart destination
     end;;

let jeu nombre_de_disques =
    clear_graph ();
    let gauche = ("A", tige_pleine 1 nombre_de_disques)
    and milieu = ("B", tige_vide 2 nombre_de_disques)
    and droite = ("C", tige_vide 3 nombre_de_disques) in
    imprime_jeu "Lucas productions presents" gauche milieu droite;
    hanoi nombre_de_disques gauche milieu droite;;

if !Sys.interactive then () else begin
  let l = Array.length Sys.argv in
  if l < 1 then begin
    prerr_endline "Usage: hanoi <number of discus>";
    exit 2 end;
  jeu (int_of_string (Sys.argv.(1)));
  exit 0
end;;



